package cn.com.duiba.tuia.core.api.remoteservice.statistics;

import cn.com.duiba.tuia.core.api.dto.statistics.AdvertLandingPageRegionDto;
import cn.com.duiba.tuia.core.api.dto.statistics.req.ReqLandingAnalysisDataDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * Created by huangch on 2017/8/24 14:10
 * description:
 *
 * @since JDK 1.6
 */
public interface RemoteAdvertLoadingPageRegionService {

    /**
     * 统计省份数据
     *
     * @param req
     * @return
     */
    DubboResult<List<AdvertLandingPageRegionDto>> statisticsLandingPageProvinceData(ReqLandingAnalysisDataDto req);

    /**
     * 统计城市数据
     *
     * @param req
     * @return
     */
    DubboResult<List<AdvertLandingPageRegionDto>> statisticsLandingPageCityData(ReqLandingAnalysisDataDto req);

    /**
     * 查询省份数据
     *
     * @param req
     * @return
     */
    DubboResult<List<AdvertLandingPageRegionDto>> listLandingPageProvinceData(ReqLandingAnalysisDataDto req);

    /**
     * 查询城市数据
     *
     * @param req
     * @return
     */
    DubboResult<List<AdvertLandingPageRegionDto>> listLandingPageCityInProvinceData(ReqLandingAnalysisDataDto req);

    /**
     * 查询所有城市数据
     *
     * @param req
     * @return
     */
    DubboResult<List<AdvertLandingPageRegionDto>> listLandingPageAllCityData(ReqLandingAnalysisDataDto req);
}
