/**
 * Project Name:tuia-core-api<br>
 * File Name:AppDto.java<br>
 * Package Name:cn.com.duiba.tuia.core.api.dto<br>
 * Date:2016年12月9日下午4:35:19<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.core.api.dto;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * ClassName: AppDto <br/>
 * date: 2016年12月9日 下午4:35:19 <br/>
 * .
 *
 * @author xiawei
 * @version
 * @since JDK 1.6
 */
public class AppDto extends BaseDto{

    /** The Constant serialVersionUID. @since JDK 1.6 */
    private static final long serialVersionUID = 7181163399141661770L;

    /** 不发放福袋. */
    public static final int   NO_SEND_LUCKYBAG = 0;

    /** 发放福袋. */
    public static final int   SEND_LUCKYBAG    = 1;

    /** 开发者id. */
    private Long              developerId;

    /** 开发者账号. */
    private String            developerAccount;

    //兼容字段
    private String            appAccount;

    /** 应用id. */
    private Long              appId;

    /** 应用名称. */
    private String            appName;

    /** 匹配标签列表. */
    private String            matchTagIds;

    /** 禁用标签列表. */
    private String            bannedTags;

    /** 禁用标签列表. */
    private String          bannedTagIds;

    /** 广告禁用标签列表. */
    private String            bannedAdvertTags;

    /** 老的禁用标签. */
    private String            oldBannedTags;

    /** 是否发放福袋：0-不发放，1-发放. */
    private Integer           isSendLuckybag;

    /** 新媒体策略屏蔽标签. */
    private String            flowBannedTags;

    /** 新媒体策略广告标签. */
    private String            flowBannedAdvertTags;

    /** app来源 0-来自兑吧，1-来自媒体平台 */
    private Integer           appSource;

    public Integer getAppSource() {
        return appSource;
    }

    public void setAppSource(Integer appSource) {
        this.appSource = appSource;
    }

    public String getAppAccount() {
        return appAccount;
    }

    public void setAppAccount(String appAccount) {
        this.appAccount = appAccount;
    }

    public String getBannedTagIds() {
        return bannedTagIds;
    }

    public void setBannedTagIds(String bannedTagIds) {
        this.bannedTagIds = bannedTagIds;
    }

    /**
     * flowBannedTags.
     *
     * @return the flowBannedTags
     */
    public String getFlowBannedTags() {
        return flowBannedTags;
    }

    /**
     * flowBannedTags.
     *
     * @param flowBannedTags the flowBannedTags to set
     */
    public void setFlowBannedTags(String flowBannedTags) {
        this.flowBannedTags = flowBannedTags;
    }

    /**
     * flowBannedAdvertTags.
     *
     * @return the flowBannedAdvertTags
     */
    public String getFlowBannedAdvertTags() {
        return flowBannedAdvertTags;
    }

    /**
     * flowBannedAdvertTags.
     *
     * @param flowBannedAdvertTags the flowBannedAdvertTags to set
     */
    public void setFlowBannedAdvertTags(String flowBannedAdvertTags) {
        this.flowBannedAdvertTags = flowBannedAdvertTags;
    }

    /**
     * Gets the developer id.
     *
     * @return the developer id
     */
    public Long getDeveloperId() {
        return developerId;
    }

    /**
     * Sets the developer id.
     *
     * @param developerId the developer id
     */
    public void setDeveloperId(Long developerId) {
        this.developerId = developerId;
    }

    /**
     * Gets the developer account.
     *
     * @return the developer account
     */
    public String getDeveloperAccount() {
        return developerAccount;
    }

    /**
     * Sets the developer account.
     *
     * @param developerAccount the developer account
     */
    public void setDeveloperAccount(String developerAccount) {
        this.developerAccount = developerAccount;
    }

    /**
     * Gets the app id.
     *
     * @return the app id
     */
    public Long getAppId() {
        return appId;
    }

    /**
     * Sets the app id.
     *
     * @param appId the app id
     */
    public void setAppId(Long appId) {
        this.appId = appId;
    }

    /**
     * Gets the app name.
     *
     * @return the app name
     */
    public String getAppName() {
        return appName;
    }

    /**
     * Sets the app name.
     *
     * @param appName the app name
     */
    public void setAppName(String appName) {
        this.appName = appName;
    }

    /**
     * Gets the match tag ids.
     *
     * @return the match tag ids
     */
    public String getMatchTagIds() {
        return matchTagIds;
    }

    /**
     * Sets the match tag ids.
     *
     * @param matchTagIds the match tag ids
     */
    public void setMatchTagIds(String matchTagIds) {
        this.matchTagIds = matchTagIds;
    }

    /**
     * Gets the banned tags.
     *
     * @return the banned tags
     */
    public String getBannedTags() {
        return bannedTags;
    }

    /**
     * Sets the banned tags.
     *
     * @param bannedTags the banned tags
     */
    public void setBannedTags(String bannedTags) {
        this.bannedTags = bannedTags;
    }

    /**
     * Gets the banned advert tags.
     *
     * @return the banned advert tags
     */
    public String getBannedAdvertTags() {
        return bannedAdvertTags;
    }

    /**
     * Sets the banned advert tags.
     *
     * @param bannedAdvertTags the banned advert tags
     */
    public void setBannedAdvertTags(String bannedAdvertTags) {
        this.bannedAdvertTags = bannedAdvertTags;
    }

    /**
     * Gets the old banned tags.
     *
     * @return the old banned tags
     */
    public String getOldBannedTags() {
        return oldBannedTags;
    }

    /**
     * Sets the old banned tags.
     *
     * @param oldBannedTags the old banned tags
     */
    public void setOldBannedTags(String oldBannedTags) {
        this.oldBannedTags = oldBannedTags;
    }

    /**
     * Gets the is send luckybag.
     *
     * @return the checks if is send luckybag
     */
    public Integer getIsSendLuckybag() {
        return isSendLuckybag;
    }

    /**
     * Sets the is send luckybag.
     *
     * @param isSendLuckybag the checks if is send luckybag
     */
    public void setIsSendLuckybag(Integer isSendLuckybag) {
        this.isSendLuckybag = isSendLuckybag;
    }

    /**
     * To string.
     *
     * @return the string
     */
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
