/**
 * Project Name:tuia-core-api<br>
 * File Name:ReqPageQueryAccount.java<br>
 * Package Name:cn.com.duiba.tuia.core.api.dto.req<br>
 * Date:2016年9月2日下午1:58:32<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.core.api.dto.req;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

import org.apache.commons.lang.builder.ToStringBuilder;

import cn.com.duiba.tuia.core.api.dto.BaseQueryDto;

/**
 * ClassName: ReqPageQueryAccount <br/>
 * Function: 查询分页广告主. <br/>
 * date: 2016年9月2日 下午1:58:32 <br/>
 *
 * @author leiliang
 * @version
 * @since JDK 1.6
 */
@ApiModel("代理商查询广告主列表参数")
public class ReqPageQueryAccount extends BaseQueryDto {

    /** The Constant serialVersionUID. */
    private static final long  serialVersionUID = 1L;

    /** The Constant CONSUMETOTAL. */
    public static final String CONSUMETOTAL     = "consumeTotal";

    /** 邮箱. */
    @ApiModelProperty("邮箱")
    private String             email;

    /** 审核状态. */
    @ApiModelProperty("审核状态")
    private Integer            checkStatus;

    /** 邮件状态. */
    @ApiModelProperty("邮件状态")
    private Integer            emailStatus;

    /** 冻结状态. */
    @ApiModelProperty("冻结状态")
    private Integer            freezeStatus;

    /** 代理商ID(如果管理后台调用， 则不用传代理商ID). */
    @ApiModelProperty(hidden = true)
    private Long               agentID;

    /** 用户类型. */
    @ApiModelProperty(hidden = true)
    private Integer            userType;

    /** 公司名称. */
    @ApiModelProperty("公司名称")
    private String             companyName;

    /** 操作员ID. */
    @ApiModelProperty("操作员ID")
    private Long               operatorId;

    /** 当日. */
    @ApiModelProperty("当日")
    private String             curDate;

    /** 操作员ID集合. */
    @ApiModelProperty("操作员ID集合")
    private List<Long>         operatorIds;

    /** 操作员名称. */
    @ApiModelProperty("操作员名称")
    private String             operatorName;

    /** 无操作员：1-标识无操作员. */
    @ApiModelProperty("无操作员：1-标识无操作员")
    private Integer            sign;

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Integer getCheckStatus() {
        return checkStatus;
    }

    public void setCheckStatus(Integer checkStatus) {
        this.checkStatus = checkStatus;
    }

    public Integer getEmailStatus() {
        return emailStatus;
    }

    public void setEmailStatus(Integer emailStatus) {
        this.emailStatus = emailStatus;
    }

    public Integer getFreezeStatus() {
        return freezeStatus;
    }

    public void setFreezeStatus(Integer freezeStatus) {
        this.freezeStatus = freezeStatus;
    }

    public Long getAgentID() {
        return agentID;
    }

    public void setAgentID(Long agentID) {
        this.agentID = agentID;
    }

    public Integer getUserType() {
        return userType;
    }

    public void setUserType(Integer userType) {
        this.userType = userType;
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public Long getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }

    public String getCurDate() {
        return curDate;
    }

    public void setCurDate(String curDate) {
        this.curDate = curDate;
    }

    public List<Long> getOperatorIds() {
        return operatorIds;
    }

    public void setOperatorIds(List<Long> operatorIds) {
        this.operatorIds = operatorIds;
    }

    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }

    public Integer getSign() {
        return sign;
    }

    public void setSign(Integer sign) {
        this.sign = sign;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
