package cn.com.duiba.tuia.core.api.enums;


/**
 * 新媒体流量策略配置位运算开关
 * date: 2017年4月17日 下午2:17:12 <br/>
 *
 * @author chencheng
 * @version
 */
public enum AppFlowStrategySwitchEnum {
    /** 策略开关. */
    STRATEGY_TYEP_STRATEGY(0, "策略开关"),

    /** 福袋开关. */
    STRATEGY_TYEP_LUCKYBAG(1, "福袋开关"),
    
    /** 代理开关. */
    STRATEGY_TYEP_PROXY(2, "代理开关");

    /** 代码 */
    private int code;
    /** 描述 */
    private String desc;

    private AppFlowStrategySwitchEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static AppFlowStrategySwitchEnum getByCode(int code) {
        for (AppFlowStrategySwitchEnum enumVal : AppFlowStrategySwitchEnum.values()) {
            if (code == enumVal.getCode()) {
                return enumVal;
            }
        }
        return null;
    }

    public int getCode() {
        return code;
    }


    public String getDesc() {
        return desc;
    }

}
