/**
 * Project Name:tuia-core-api<br>
 * File Name:RemoteAdvertDuibaItemBackendService.java<br>
 * Package Name:cn.com.duiba.tuia.core.api.remoteservice<br>
 * Date:2016年11月9日下午12:57:05<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.core.api.remoteservice;

import java.util.List;

import cn.com.duiba.tuia.core.api.dto.AdvertDuibaItemDto;
import cn.com.duiba.tuia.core.api.dto.BaseAmountDto;
import cn.com.duiba.tuia.core.api.dto.rsp.RspAdvertDuibaItemDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName: RemoteAdvertDuibaItemBackendService <br/>
 * Function: 推啊广告和兑吧兑换项关联. <br/>
 * date: 2016年11月9日 下午12:57:05 <br/>
 *
 * @author guyan
 * @version
 * @since JDK 1.6
 */
public interface RemoteAdvertDuibaItemBackendService {

    /**
     * 查询单个广告的关联列表.<br>
     * [使用说明]
     * <ol>
     * <li>relationState=1：查询当前广告关联状态为true的Item列表</li>
     * <li>relationState=0：查询当前广告关联状态为false的Item列表</li>
     * <li>relationState=null：查询当前广告关联过(当前为关联状态或者曾经关联过但现在解除关联了)的Item列表</li>
     * </ol>
     *
     * @param advertId the advert id
     * @param relationState the relation state
     * @return the dubbo result< RspAdvertDuibaItemDto>
     */
    DubboResult<List<AdvertDuibaItemDto>> selectListByRelationState(Long advertId, Integer relationState);

    /**
     * 更新关联广告信息. <br/>
     *
     * @param advertId the advert id
     * @param list the list
     * @return the dubbo result< boolean>
     */
    DubboResult<Boolean> updateAdvertDuibaItem(Long advertId, List<AdvertDuibaItemDto> list);

    /**
     * 已存在关联关系. <br/>
     *
     * @param id the id
     * @return the dubbo result< boolean>
     */

    DubboResult<RspAdvertDuibaItemDto> selectDuibaData(Long id);

    /**
     * 批量查询关联列表. <br>
     * [使用说明]
     * <ol>
     * <li>relationState=1：查询当前广告关联状态为true的Item列表</li>
     * <li>relationState=0：查询当前广告关联状态为false的Item列表</li>
     * <li>relationState=null：查询当前广告关联过(当前为关联状态或者曾经关联过但现在解除关联了)的Item列表</li>
     * </ol>
     *
     * @param advertIds the advert ids
     * @param relationState the relation state
     * @return the duiaba item by ids
     */
    DubboResult<List<AdvertDuibaItemDto>> getDuiabaItemByIds(List<Long> advertIds, Integer relationState);

    /**
     * 统计关联对吧广告数量. <br/>
     *
     * @param advertIds the advert ids
     * @return the dubbo result< list< base amount dto>>
     * @since JDK 1.6
     */
    DubboResult<List<BaseAmountDto>> selectAmountByAdvertIds(List<Long> advertIds);
}
