package cn.com.duiba.tuia.core.api.remoteservice.advert;

import cn.com.duiba.tuia.core.api.dto.advert.AdvertTargetAppDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * Created by huangch on 2017/8/29 13:48
 * description:
 *
 * @since JDK 1.6
 */
public interface RemoteAdvertTargetAppService {

    /**
     * 通过广告ID查询关联的定向媒体App.
     *
     * @param advertId    the advert id
     * @param orientPkgId
     * @return the list< long>
     */
    DubboResult<AdvertTargetAppDto> selectAppByAdvertId(Long advertId, Long orientPkgId);

    /**
     * 更新该广告绑定的app.
     *
     * @param req the req
     * @return the int
     */
    DubboResult<Integer> updateBindApp(AdvertTargetAppDto req);

    /**
     * 如果该广告没有关联定向媒体,则插入一条记录.
     *
     * @param req the req
     */
    DubboResult<Integer> insert(AdvertTargetAppDto req);
}
