package cn.com.duiba.tuia.core.api.remoteservice.statistics;

import cn.com.duiba.tuia.core.api.dto.AdvertStatisticsDayDto;
import cn.com.duiba.tuia.core.api.dto.PageDto;
import cn.com.duiba.tuia.core.api.dto.req.ReqGetAdvertStatisDataDto;
import cn.com.duiba.tuia.core.api.statistics.domain.*;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.Date;
import java.util.List;

/**
 * @author: <a href="http://www.panaihua.com">panaihua</a>
 * @date: 2017年06月13日 14:40
 * @descript:
 * @version: 1.0
 */
public interface RemoteAdvertAppStatisticsService {

    /**
     * 查询广告统计数据.
     *
     * @param req the req
     * @return AdvertStatisticsDayDO 广告统计信息
     */
    DubboResult<List<AdvertStatisticsRsp>> getAdvertStatisticsByAdvertName(GetAdvertStatisticsReq req);

    /**
     * 统计广告数据
     * @param req
     * @return
     */
    DubboResult<Integer> getAdvertStatisticsByAdvertNameCount(GetAdvertStatisticsReq req);


    /**
     * 查询广告列表排序分页信息.
     *
     * @param req the req
     * @return the page advert data list
     */
    DubboResult<PageDto<AdvertStatisticsRsp>> getPageAdvertDataList(GetAdvertStatisticsReq req);

    /**
     * 获取每天数据
     * @param req
     * @return
     */
    DubboResult<List<GetDailyDataRsp>> getDailyData(GetDailyDataReq req);

    /**
     * 获取每天数据的总和
     * @param req
     * @return
     */
    DubboResult<Integer> getDailyDataAmount(GetDailyDataReq req);

    DubboResult<Integer> getAppDataAmount(GetAppDataReq req);

    DubboResult<GetAppDataRsp> selectAppCountData(GetAppDataReq req);

    DubboResult<List<GetAppDataRsp>> getAppData(GetAppDataReq req);

    DubboResult<List<GetAppDataRsp>> getAppDailyData(GetAppDataReq req);

    DubboResult<Integer> countAppDailyData(GetAppDataReq req);

    DubboResult<Integer> getAdvertDataAmountByDaily(Date startTime, Date endTime, List<Long> advertIds);

    DubboResult<List<AdvertStatisticsDayDto>> getAdvertDataByAgentId(Date startDate, Date endDate, Long agentId);

    DubboResult<List<AdvertStatisticsDayDto>> getAdvertDataByAccountId(Long accountId, Date startDate, Date endDate);

    /**
     * 查询广告主数据总(条)数.
     *
     * @param req the req
     * @return the statistics
     */
    DubboResult<Integer> getAdvertiserDataAmount(GetAdvertiserDataReq req);

    /**
     * 查询广告主数据.
     *
     * @param req the req
     * @return the daily data
     */
    DubboResult<List<GetAdvertiserDataRsp>> getAdvertiserData(GetAdvertiserDataReq req);

    DubboResult<List<AdvertStatisticsDayDto>> getByAdvertIds(List<Long> advertIds, String startDate, String endDate);

    DubboResult<List<AdvertStatisticsDayDto>> getDailyDateByPage(ReqGetAdvertStatisDataDto getAdvertStatisDataDto);

    DubboResult<List<AdvertStatisticsDayDto>> getListByAdvertIds(ReqGetAdvertStatisDataDto reqGetAdvertStatisDataDto);

    /**
     * 获取代理商的账号
     * @param agentId
     * @return
     */
    DubboResult<Integer> getNumOfConsumeAdvertiser(Long agentId);

    /**
     * 通过itemIds集合去广告数据统计表中查询出每日统计信息
     * @param reqGetAdvertStatisDataDto
     * @return
     */
    DubboResult<List<AdvertStatisticsDayDto>> getDuiabaItemDailyDataByIds(ReqGetAdvertStatisDataDto reqGetAdvertStatisDataDto);


    DubboResult<List<GetDailyDataRsp>> getAdvertStatisticsByIds(GetAdvertStatisticsReq req);
}
