/**
 * 文件名： ByDateQueryReq.java 此类描述的是： 作者: leiliang 创建时间: 2016年4月21日 上午10:54:21
 */
package cn.com.duiba.tuia.core.api.dto;

import java.util.Date;

import org.apache.commons.lang.builder.ToStringBuilder;


/**
 * 按日期分页查询
 * 
 * @author: leiliang
 * @version:
 */
public class BaseQueryDateReq extends BaseQueryDto {

    /** serialVersionUID */
    private static final long serialVersionUID = 4406772343475710601L;

    /** 开始时间. */
    private Date            startDate;

    /** 结束时间. */
    private Date            endDate;


    /**
     * Creates a new instance of ByDateQueryReq.
     */

    public BaseQueryDateReq() {
        super();
    }

    /**
     * Creates a new instance of ByDateQueryReq.
     *
     * @param startDate
     * @param endDate
     */

    public BaseQueryDateReq(Date startDate, Date endDate) {
        super();
        this.startDate = startDate;
        this.endDate = endDate;
    }

    /**
     * startDate.
     *
     * @return the startDate
     * @since JDK 1.7
     */
    public Date getStartDate() {
        return startDate;
    }

    /**
     * startDate.
     *
     * @param startDate the startDate to set
     * @since JDK 1.7
     */
    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    /**
     * endDate.
     *
     * @return the endDate
     * @since JDK 1.7
     */
    public Date getEndDate() {
        return endDate;
    }

    /**
     * endDate.
     *
     * @param endDate the endDate to set
     * @since JDK 1.7
     */
    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    /**
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
