package cn.com.duiba.tuia.core.api.enums;

import org.apache.commons.lang.StringUtils;

/**
 * 新媒体流量策略配置 date: 2017年4月17日 下午2:17:12 <br/>
 *
 * @author chencheng
 * @version
 */
public enum AppFlowStrategySignEnum {
    /** 默认流量策略. */
    STRATEGY_TYEP_DEFAULT("", "默认流量策略"),

    /** 新媒体流量策略. */
    STRATEGY_TYEP_FLOW("flow", "新媒体流量策略");

    /** 代码 */
    private String code;
    /** 描述 */
    private String desc;

    private AppFlowStrategySignEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static AppFlowStrategySignEnum getByCode(String code) {
        for (AppFlowStrategySignEnum enumVal : AppFlowStrategySignEnum.values()) {
            if (StringUtils.equals(code, enumVal.getCode())) {
                return enumVal;
            }
        }
        return null;
    }

    public String getCode() {
        return code;
    }


    public String getDesc() {
        return desc;
    }


}
