/**
 * Project Name:tuia-core-api<br>
 * File Name:RemoteAccountBackendService.java<br>
 * Package Name:cn.com.duiba.tuia.core.api.remoteservice<br>
 * Date:2016年8月23日上午11:11:53<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.core.api.remoteservice;

import java.util.List;

import cn.com.duiba.tuia.core.api.dto.*;
import cn.com.duiba.tuia.core.api.dto.advertiser.req.ReqPageQueryAdvertiserDto;
import cn.com.duiba.tuia.core.api.dto.req.*;
import cn.com.duiba.tuia.core.api.dto.req.account.ReqAccountEditDto;
import cn.com.duiba.tuia.core.api.dto.rsp.RspAderStatInfoDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName: RemoteAccountBackendService <br/>
 * Function: 用户. <br/>
 * date: 2016年8月23日 上午11:11:53 <br/>
 *
 * @author leiliang
 * @version
 * @since JDK 1.6
 */
public interface RemoteAccountBackendService {

    /**
     * 注册.
     *
     * @param req the req
     * @param userType the user type
     * @return the dubbo result< long>
     */
    DubboResult<AccountDto> register(ReqRegisterDto req, int userType);

    /**
     * 创建账号.
     *
     * @param accountDto 账号信息
     * @param bindingOperator 绑定操作员
     * @return the dubbo result< boolean>
     */
    DubboResult<Boolean> createAdvertiser(AccountDto accountDto, Long bindingOperator);

    /**
     * 重置密码.
     *
     * @param email 邮箱
     * @param newPasswd 新密码
     * @return the dubbo result< boolean>
     */
    DubboResult<Boolean> resetPassword(String email, String newPasswd);

    /**
     * 更新邮箱审核状态.
     *
     * @param email the email
     * @return the dubbo result< boolean>
     */
    DubboResult<BaseAccountDto> updateEmailStatus(String email);

    /**
     * 账号审核.
     *
     * @param id 账号ID
     * @param checkType 审核类型
     * @param checker 审核人
     * @param checkerContact the checker contact
     * @param reason 原因
     * @return the int
     */
    DubboResult<Boolean> updateCheckStatus(long id, int checkType, String checker, String checkerContact, String reason);

    /**
     * 账号冻结与解冻.
     *
     * @param accoutId 广告主账户ID
     * @param status 冻结或解冻状态值
     * @param reason 冻结原因
     * @return the int
     */
    DubboResult<Boolean> updateFreezeStatus(long accoutId, int status, String reason);

    /**
     * 更新账号信息.
     *
     * @param updateAccountDto the update account dto
     * @return the dubbo result< boolean>
     */
    DubboResult<Boolean> updateAccount(ReqUpdateAccountDto updateAccountDto);

    /**
     * 修改广告主信息.
     *
     * @param reqUpdateAdvertiserDto the req update advertiser dto
     * @return the dubbo result< boolean>
     */
    DubboResult<Boolean> updateAdvertiser(ReqUpdateAdvertiserDto reqUpdateAdvertiserDto);

    /**
     * 更新审核材料.
     *
     * @param req the req
     * @return the dubbo result< boolean>
     */
    DubboResult<Boolean> updateAuditData(ReqUpdateAuditData req);

    /**
     * 更新审核材料.
     *
     * @param reqUpdateAdvertiserAuditData the req update advertiser audit data
     * @return the dubbo result< boolean>
     */
    DubboResult<Boolean> updateAdvertiserAuditData(ReqUpdateAdvertiserAuditData reqUpdateAdvertiserAuditData);

    /**
     * 通过邮箱查询账号信息.
     *
     * @param email 邮箱
     * @return 账号信息
     */
    DubboResult<AccountDto> getAccountByEmail(String email);

    /**
     * 通过账号ID查询账号信息.
     *
     * @param accountId 账号ID
     * @return 账号信息
     */
    DubboResult<AccountDto> getAccountById(long accountId);

    /**
     * 分页查询广告主.
     *
     * @param req 分页查询请求参数
     * @return 广告主查询结果
     */
    DubboResult<PageDto<AdvertiserSumInfoDto>> pageQuery(ReqPageQueryAccount req);

    /**
     * 得到最新的审核记录. <br/>
     *
     * @param accountId the account id
     * @param checkType the check type
     * @return the account check record
     * @author ZFZ
     * @since JDK 1.6
     */
    DubboResult<AccountCheckRecordDto> getAccountCheckRecord(long accountId, int checkType);

    /**
     * 查询代理商帐号id旗下广告主帐号数量. <br/>
     *
     * @param agentAccountId the agent account id
     * @return the advertiser count
     * @author sunjiangrong
     * @since JDK 1.6
     */
    public DubboResult<Integer> getAdvertiserCount(long agentAccountId);

    /**
     * 根据ID列表获取账户基本信息. <br/>
     *
     * @param ids the ids
     * @return the dubbo result< list< base account dto>>
     * @author sunjiangrong
     * @since JDK 1.6
     */
    DubboResult<List<BaseAccountDto>> selectAccountBaseInfoByIds(List<Long> ids);

    /**
     * 查询代理商下(邮箱已验证、审核通过、未冻结的)广告主.
     * 该方法返回的只有基本的id、agentId、email和name，若需要全量的信息请使用selectAdvertisersByAgentId方法
     *
     * @param agentId 代理商ID
     * @return 广告主基本信息列表
     * @see RemoteAccountBackendService#selectAdvertisersByAgentId(java.lang.Long)
     */
    DubboResult<List<BaseAccountDto>> getAdvertisersByAgentId(Long agentId);

    /**
     * 查询广告主全量信息.
     *
     * @param agentId 代理商ID
     * @return 广告主信息列表
     */
    DubboResult<List<AccountDto>> selectAdvertisersByAgentId(Long agentId);

    /**
     * 通过eamils查询代理商ids <br/>.
     *
     * @param emails the emails
     * @return the agent ids
     * @since JDK 1.6
     */
    DubboResult<List<Long>> getAgentIds(List<String> emails);

    /**
     * 代理商首页查询广告主信息.
     *
     * @param agentId the agent id
     * @return the ader stat info
     */
    DubboResult<RspAderStatInfoDto> getAderStatInfo(Long agentId);

    /**
     * 申请预约信息保存
     *
     * @author chencheng
     * @param reqAppointmentInfo
     * @return
     */
    DubboResult<Boolean> appointmentApply(ReqAppointmentInfo reqAppointmentInfo);

    /**
     * 根据代理商名称模糊id列表
     * @param agentName  代理商名称
     * @return
     */
    DubboResult<List<Long>> getAgentIdsByName(String agentName);


    DubboResult<List<Long>> getAccountIdsByName(String advertiserName);

    /**
     * 批量更新广告主(代理商)账号状态
     *
     * @param accountIds 代理商id
     * @param updateType 0:审核状态，1:冻结状态，3:邮箱状态
     * @param status     对应状态的值
     * @return
     */
    DubboResult<Boolean> updateAccountStatus(List<Long> accountIds, int updateType, int status);

    /**
     * 分页查询
     *
     * @param req 查询参数
     * @return
     */
    DubboResult<List<AdvertiserSumInfoDto>> pageQuery(ReqPageQueryAdvertiserDto req);

    /**
     * 分页查询计数
     *
     * @param req 查询参数
     * @return
     */
    DubboResult<Integer> getPageQueryAmount(ReqPageQueryAdvertiserDto req);

    /**
     * 批量查询广告主
     *
     * @param advertiserIds 广告主id
     * @return 广告主
     */
    DubboResult<List<AccountDto>> selectAdvertiserListByIds(List<Long> advertiserIds);

    /**
     * 通过companyName和agentName查询广告主id
     *
     * @param companyName
     * @param agentCompanyName
     * @return
     */
    DubboResult<List<Long>> selectAdvertiserIdsByName(String companyName, String agentCompanyName);

    /**
     * 修改帐号信息
     * 
     * @param changeDto 修改的信息
     * @return true 修改成功 false 修改失败
     */
    DubboResult<Boolean> changeAccountInfo(ReqAccountEditDto changeDto);
}
