
/**
 * Project Name:tuia-core-api<br>
 * File Name:RemoteAdvertCouponBackendService.java<br>
 * Package Name:cn.com.duiba.tuia.core.api.remoteservice<br>
 * Date:2017年1月17日下午8:32:03<br>
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.<br>
 *
 */

package cn.com.duiba.tuia.core.api.remoteservice;

import java.util.List;

import cn.com.duiba.tuia.core.api.dto.ActivityCouponDto;
import cn.com.duiba.wolf.dubbo.DubboResult;


/**
 * 提供给活动管理模块的优惠券查询服务
 * ClassName: RemoteAdvertCouponBackendService <br/>
 * Function: 广告券码. <br/>
 * date: 2017年1月17日 下午8:32:03 <br/>
 *
 * @author leiliang
 * @version 
 * @since JDK 1.6
 */
public interface RemoteCouponBackendService {

    /**
     * 根据广告名称模糊查询.
     * 排除有定向媒体的广告券
     * @param name the name
     * @return the coupons by name
     */
    DubboResult<List<ActivityCouponDto>> getCouponsByName(String name);
    
    /**
     * 根据广告券商品ID查询商品库存信息
     *
     * @param id the id
     * @return the coupon by id
     */
    DubboResult<ActivityCouponDto> getCouponById(Long id);
}

