package cn.com.duiba.tuia.core.api.remoteservice.advertiser;

import cn.com.duiba.tuia.core.api.dto.advertiser.ActivityAdvertWhitelistDto;
import cn.com.duiba.tuia.core.api.dto.advertiser.req.ReqActivityConnAdvertDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * Created by huangch on 2017/8/22 17:27
 * description:
 *
 * @since JDK 1.6
 */
public interface RemoteActivityAdvertWhitelistService {

    /**
     * 插入活动与广告的关联关系数据
     *
     * @param activityTypeId 活动类型id
     * @param activityId     活动id
     * @param advertiserId   广告主id
     * @param advertId       广告id
     * @param operator       操作员
     * @return 插入状态
     */
    DubboResult<Integer> insert(Integer activityTypeId, Long activityId, Long advertiserId, Long advertId, String operator);

    /**
     * 通过id查询配置活动
     *
     * @param id 查询id
     * @return 查询配置活动与广告的关联关系数据
     */
    DubboResult<ActivityAdvertWhitelistDto> selectById(Long id);

    /**
     * 通过活动类型ID、活动ID和广告ID查询活动与广告关联关系
     *
     * @param activityTypeId 活动类型id
     * @param activityId     活动id
     * @param advertId       广告id
     * @return 活动与广告关联关系数据
     */
    DubboResult<ActivityAdvertWhitelistDto> selectByActivityIdAndAdvertId(Integer activityTypeId, Long activityId, Long advertId);

    /**
     * 分页查询活动与广告关联关系数据
     *
     * @param req 查询参数
     * @return 分页结果
     */
    DubboResult<List<ActivityAdvertWhitelistDto>> selectPageQuery(ReqActivityConnAdvertDto req);

    /**
     * 查询活动白名单总数
     *
     * @param req 查询参数
     * @return 查询总数
     */
    DubboResult<Integer> selectPageQueryAmount(ReqActivityConnAdvertDto req);

    /**
     * 根据id查出数据
     *
     * @param id 需要删除的id
     * @return 删除状态
     */
    DubboResult<Integer> delete(Long id);

    /**
     * 通过活动类型ID、活动ID查询关联的广告ID集合
     *
     * @param activityTypeId 活动类型id
     * @param activityId     活动id
     * @return 活动与关联的广告ID集合
     */
    DubboResult<List<Long>> selectActivityConnAdvertIds(Integer activityTypeId, Long activityId);

    /**
     * 通过活动类型ID、活动ID查询关联的广告主ID集合
     *
     * @param activityTypeId 活动类型id
     * @param activityId     活动id
     * @return 关联的广告主ID集合
     */
    DubboResult<List<Long>> selectActivityConnAdverisertIds(Integer activityTypeId, Long activityId);
}
