package cn.com.duiba.tuia.core.api.remoteservice.permisson;

import java.util.List;

import cn.com.duiba.tuia.core.api.dto.permisson.MenuDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * Created by lizhihui on 2017-08-24 16:53.
 */
public interface RemoteMenuService {

    /**
     * 根据类型获取菜单列表
     * 
     * @param type 类型:1-manager 0-web
     * @return 菜单列表
     */
    DubboResult<List<MenuDto>> listByType(Integer type);

    /**
     * 根据menuId列表获取菜单列表
     * 
     * @param ids 菜单id列表
     * @return 菜单详情列表
     */
    DubboResult<List<MenuDto>> listByIds(List<Long> ids);

    /**
     * 根据菜单id列表获取 三级列表
     * 
     * @param ids 菜单id列表
     * @return 三级菜单列表
     */
    DubboResult<List<MenuDto>> listThirdLevelByIds(List<Long> ids);

    /**
     * 根据角色id获取菜单列表
     * 
     * @param roleId 角色
     * @return 菜单列表
     */
    DubboResult<List<MenuDto>> listByRoleId(Long roleId);

    /**
     * 根据角色id列表获取菜单列表
     *
     * @param roleIds 角色列表
     * @return 菜单列表
     */
    DubboResult<List<MenuDto>> listByRoleIds(List<Long> roleIds);
}
