package cn.com.duiba.tuia.core.api.remoteservice.advertiser;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.advertiser.AccountRechargeRecordDto;
import cn.com.duiba.tuia.core.api.dto.finance.RechargeRecordSummaryDataDto;
import cn.com.duiba.tuia.core.api.dto.req.account.AccountRechargeRecordQueryDto;

import java.util.List;

/**
 * Created by huangch on 2017/8/21 17:22 description: 代理商充值记录服务
 *
 * @since JDK 1.6
 */
@AdvancedFeignClient
public interface RemoteAccountRechargeRecordBackendService {

    /**
     * 根据条件查询充值记录
     * 
     * @param queryDto 查询条件
     * @return 符合条件的
     */
    List<AccountRechargeRecordDto> list(AccountRechargeRecordQueryDto queryDto);

    /**
     * 统计符合条件的充值记录数
     * 
     * @param queryDto 统计条件
     * @return 符合条件的条数
     */
    int count(AccountRechargeRecordQueryDto queryDto);

    /**
     * 查询充值记录的汇总数据
     *
     * @param req ~
     * @return 汇总数据
     */
    RechargeRecordSummaryDataDto selectSummaryData(AccountRechargeRecordQueryDto req);
}
