package cn.com.duiba.tuia.core.api.remoteservice;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import java.util.List;

import cn.com.duiba.tuia.core.api.dto.AdvertLimitDto;
import cn.com.duiba.tuia.core.api.dto.rsp.RspAvertLimitingCountDto;
import cn.com.duiba.tuia.core.api.dto.rsp.RspAvertLimitingDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * @author: panaihua
 * @date: 2017年02月27日 19:09
 * @descript:
 * @version: 1.0
 */
@AdvancedFeignClient
public interface RemoteAdvertLimitingService {

	/**
	 * 更新限流媒体日预算和生效日期
	 * @param LimitingDto
	 * @return
	 * @throws TuiaCoreException
	 * @since JDK 1.6
	 */
	DubboResult<Integer> updateAdvertLimitingById(AdvertLimitDto LimitingDto);
	
    /**
     * 添加限流媒体
     * @param list
     * @return
     */
    DubboResult<Boolean> addLimiting(List<AdvertLimitDto> list);

    /**
     * 根据限流媒体编号和应用编号获取限流媒体
     * @param advertId
     * @param appIds
     * @param orientPkgId
     * @return
     */
    DubboResult<List<RspAvertLimitingDto>> getLimitingByQuery(Long advertId,List<Long> appIds, Long orientPkgId);
    
    /**
     * 
     * selectLimitAdvert:(查询广告的限流媒体个数). <br/>
     *
     * @author chencheng
     * @param advertId 广告id,选填,为空查询全部
     * @return 
     * @since JDK 1.8
     */
    DubboResult<List<RspAvertLimitingCountDto>> selectLimitAdvertCount(Long advertId);
}
