/**
 * Project Name:manager-domain<br>
 * File Name:AdvertStatisticsData.java<br>
 * Package Name:cn.com.duiba.tuia.manager.model<br>
 * Date:2016年5月24日下午2:10:36<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.core.api.statistics.domain;

import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang.builder.ToStringBuilder;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * ClassName:AdvertStatisticsData <br/>
 * Function: 广告统计数据(发券量、曝光量、点击数、计费点击、点击UV、点击率、花费、点击均价). <br/>
 * Reason: . <br/>
 * Date: 2016年5月24日 下午2:10:36 <br/>
 * 
 * @author Administrator
 * @version
 * @since JDK 1.6
 * @see
 */
public class AdvertStatisticsData implements Serializable {

    private static final long serialVersionUID = -5959828724539396651L;
    private Long              advertId;
    /** 发券量. */
    @ApiModelProperty(value = "发券量")
    private Long              launchCount;

    /** 曝光量. */
    @ApiModelProperty(value = "曝光量")
    private Long              exposureCount;

    /** 点击数. */
    @ApiModelProperty(value = "点击数")
    private Long              clickCount;

    /** 有效点击. */
    @ApiModelProperty(value = "有效点击")
    private Long              efClickCount;

    /** 点击率. */
    @ApiModelProperty(value = "点击率")
    private Float             clickRate;

    /** 花费. */
    @ApiModelProperty(value = "花费")
    private Long              consumeTotal;

    @ApiModelProperty(value = "作弊消耗")
    private Long              cheatConsume;

    /** 点击均价. */
    @ApiModelProperty(value = "点击均价")
    private Integer           averagePrice;

    /** 点击UV. */
    @ApiModelProperty(value = "点击UV")
    private Long              clickUV;

    /** 落地页访问pv */
    @ApiModelProperty(value = "落地页访问pv")
    private Long              visitPv;

    /** 落地页效果pv */
    @ApiModelProperty(value = "落地页效果pv")
    private Long              effectPv;

    /** 落地页访问uv */
    @ApiModelProperty(value = "落地页访问uv")
    private Long              visitUv;

    /** 落地页效果uv */
    @ApiModelProperty(value = "落地页效果uv")
    private Long              effectUv;

    /** 转化成本（PV）消耗/转化pv */
    private String            effectCost;
    
    /** 落地页损耗（落地页访问 PV / 计费点击） */
    @ApiModelProperty(value = "落地页损耗")
    private Float             loss;

    /** CVR（转化PV / 计费点击） */
    @ApiModelProperty(value = "CVR")
    private Float             cvr;

    @ApiModelProperty(value = "成本")
    private Double cost;

    /** js的计费点击 */
    @ApiModelProperty(value = "js的计费点击")
    private Long              jsEffectClickCount;

    public Double getCost() {
        return cost;
    }

    public void setCost(Double cost) {
        this.cost = cost;
    }

    public Long getCheatConsume() {
        return cheatConsume;
    }

    public void setCheatConsume(Long cheatConsume) {
        this.cheatConsume = cheatConsume;
    }

    public Long getAdvertId() {
        return advertId;
    }

    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    public Long getJsEffectClickCount() {
        return jsEffectClickCount;
    }

    public void setJsEffectClickCount(Long jsEffectClickCount) {
        this.jsEffectClickCount = jsEffectClickCount;
    }

    /**
     * visitUv.
     *
     * @return the visitUv
     */
    public Long getVisitUv() {
        return visitUv;
    }

    /**
     * visitUv.
     *
     * @param visitUv the visitUv to set
     */
    public void setVisitUv(Long visitUv) {
        this.visitUv = visitUv;
    }

    /**
     * effectUv.
     *
     * @return the effectUv
     */
    public Long getEffectUv() {
        return effectUv;
    }

    /**
     * effectUv.
     *
     * @param effectUv the effectUv to set
     */
    public void setEffectUv(Long effectUv) {
        this.effectUv = effectUv;
    }

    /**
     * visitPv.
     *
     * @return the visitPv
     */
    public Long getVisitPv() {
        return visitPv;
    }

    /**
     * visitPv.
     *
     * @param visitPv the visitPv to set
     */
    public void setVisitPv(Long visitPv) {
        this.visitPv = visitPv;
    }

    /**
     * effectPv.
     *
     * @return the effectPv
     */
    public Long getEffectPv() {
        return effectPv;
    }

    /**
     * effectPv.
     *
     * @param effectPv the effectPv to set
     */
    public void setEffectPv(Long effectPv) {
        this.effectPv = effectPv;
    }

    /**
     * loss.
     *
     * @return the loss
     */
    public Float getLoss() {
        return loss;
    }

    /**
     * loss.
     *
     * @param loss the loss to set
     */
    public void setLoss(Float loss) {
        this.loss = loss;
    }

    /**
     * cvr.
     *
     * @return the cvr
     */
    public Float getCvr() {
        return cvr;
    }

    /**
     * cvr.
     *
     * @param cvr the cvr to set
     */
    public void setCvr(Float cvr) {
        this.cvr = cvr;
    }

    /**
     * launchCount.
     *
     * @return the launchCount
     * @since JDK 1.6
     */
    public Long getLaunchCount() {
        return launchCount;
    }

    /**
     * launchCount.
     *
     * @param launchCount the launchCount to set
     * @since JDK 1.6
     */
    public void setLaunchCount(Long launchCount) {
        this.launchCount = launchCount;
    }

    /**
     * exposureCount.
     *
     * @return the exposureCount
     * @since JDK 1.6
     */
    public Long getExposureCount() {
        return exposureCount;
    }

    /**
     * exposureCount.
     *
     * @param exposureCount the exposureCount to set
     * @since JDK 1.6
     */
    public void setExposureCount(Long exposureCount) {
        this.exposureCount = exposureCount;
    }

    /**
     * clickCount.
     *
     * @return the clickCount
     * @since JDK 1.6
     */
    public Long getClickCount() {
        return clickCount;
    }

    /**
     * clickCount.
     *
     * @param clickCount the clickCount to set
     * @since JDK 1.6
     */
    public void setClickCount(Long clickCount) {
        this.clickCount = clickCount;
    }

    /**
     * efClickCount.
     *
     * @return the efClickCount
     * @since JDK 1.6
     */
    public Long getEfClickCount() {
        return efClickCount;
    }

    /**
     * efClickCount.
     *
     * @param efClickCount the efClickCount to set
     * @since JDK 1.6
     */
    public void setEfClickCount(Long efClickCount) {
        this.efClickCount = efClickCount;
    }

    /**
     * clickRate.
     *
     * @return the clickRate
     * @since JDK 1.6
     */
    public Float getClickRate() {
        return clickRate;
    }

    /**
     * clickRate.
     *
     * @param clickRate the clickRate to set
     * @since JDK 1.6
     */
    public void setClickRate(Float clickRate) {
        this.clickRate = clickRate;
    }

    /**
     * consumeTotal.
     *
     * @return the consumeTotal
     * @since JDK 1.6
     */
    public Long getConsumeTotal() {
        return consumeTotal;
    }

    /**
     * consumeTotal.
     *
     * @param consumeTotal the consumeTotal to set
     * @since JDK 1.6
     */
    public void setConsumeTotal(Long consumeTotal) {
        this.consumeTotal = consumeTotal;
    }

    /**
     * averagePrice.
     *
     * @return the averagePrice
     * @since JDK 1.6
     */
    public Integer getAveragePrice() {
        return averagePrice;
    }

    /**
     * averagePrice.
     *
     * @param averagePrice the averagePrice to set
     * @since JDK 1.6
     */
    public void setAveragePrice(Integer averagePrice) {
        this.averagePrice = averagePrice;
    }

    /**
     * Gets the click uv.
     *
     * @return the click uv
     */
    public Long getClickUV() {
        return clickUV;
    }

    /**
     * Sets the click uv.
     *
     * @param clickUV the click uv
     */
    public void setClickUV(Long clickUV) {
        this.clickUV = clickUV;
    }



    
    /**
     * effectCost.
     *
     * @return  the effectCost
     * @since   JDK 1.8
     */
    public String getEffectCost() {
        return effectCost;
    }

    
    /**
     * effectCost.
     *
     * @param   effectCost    the effectCost to set
     * @since   JDK 1.8
     */
    public void setEffectCost(String effectCost) {
        this.effectCost = effectCost;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
