package cn.com.duiba.tuia.core.api.dto.finance;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * Created by huangch on 2017/12/11 14:18
 * description:
 *
 * @since JDK 1.6
 */
public class AccountFinanceInvoiceDto implements Serializable {

    private static final long serialVersionUID = 2052852786217200773L;

    //主键id
    private Long id;
    //代理商开票信息主键id
    private Long financeInvoiceId;
    //账户id(代理商或者直客)
    private Long accountId;
    //公司名称
    private String companyName;
    //发票类型，1-专票，2-普票
    private Integer invoiceType;
    //纳税人识别号(税号)
    private String taxIdentificationNumber;
    //公司地址
    private String companyAddress;
    //公司电话号码
    private String companyTelephone;
    //收票单位开户银行
    private String depositBank;
    //银行账号
    private String bankAccount;
    //发票备注信息
    private String invoiceRemark;
    //发票的收货地址
    private String deliveryAddress;
    //发票收件人
    private String invoiceReceiver;
    //收件电话
    private String receivePhone;
    //需要开票的现金支出日期，用于计算开票金额
    private List<String> cashOutDateList;
    //发票金额(分)
    private Long invoiceAmount;
    //返货金额
    private Long cashBackAmount;
    //支出同金额
    private Long totalCashOut;
    //申请开票日期
    private Date applyDate;
    //发票状态，1-申请开票、2-已开票、3-已拒绝、4-已确认收票
    private Integer invoiceStatus;
    //快递单号
    private String courierNumber;
    //拒绝理由
    private String refuseReason;
    //自动确认收票时间（已开票时计算出自动确认收票时间，当invoiceStatus=3或者当前时间大于此值均视为已确认收票）
    private Date autoConfirmInvoiceTime;
    //是否可以修改公司名称,true可以，false不可以
    private Boolean canModifyCompanyName;
    //本月已经开票次数,此值大于2就不能开票了
    private Integer curMonthInvoiceNum;
    //发票对应的现金支出详细记录列表
    private List<InvoiceCashOutRecordDto> invoiceCashOutRecordList;

    public Long getFinanceInvoiceId() {
        return this.id;
    }

    public void setFinanceInvoiceId(Long financeInvoiceId) {
        this.financeInvoiceId = financeInvoiceId;
    }

    public Long getCashBackAmount() {
        return cashBackAmount;
    }

    public void setCashBackAmount(Long cashBackAmount) {
        this.cashBackAmount = cashBackAmount;
    }

    public Long getTotalCashOut() {
        return totalCashOut;
    }

    public void setTotalCashOut(Long totalCashOut) {
        this.totalCashOut = totalCashOut;
    }

    public List<InvoiceCashOutRecordDto> getInvoiceCashOutRecordList() {
        return invoiceCashOutRecordList;
    }

    public void setInvoiceCashOutRecordList(List<InvoiceCashOutRecordDto> invoiceCashOutRecordList) {
        this.invoiceCashOutRecordList = invoiceCashOutRecordList;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public List<String> getCashOutDateList() {
        return cashOutDateList;
    }

    public void setCashOutDateList(List<String> cashOutDateList) {
        this.cashOutDateList = cashOutDateList;
    }

    public Long getAccountId() {
        return accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public Integer getInvoiceType() {
        return invoiceType;
    }

    public void setInvoiceType(Integer invoiceType) {
        this.invoiceType = invoiceType;
    }

    public String getTaxIdentificationNumber() {
        return taxIdentificationNumber;
    }

    public void setTaxIdentificationNumber(String taxIdentificationNumber) {
        this.taxIdentificationNumber = taxIdentificationNumber;
    }

    public String getCompanyAddress() {
        return companyAddress;
    }

    public void setCompanyAddress(String companyAddress) {
        this.companyAddress = companyAddress;
    }

    public String getCompanyTelephone() {
        return companyTelephone;
    }

    public void setCompanyTelephone(String companyTelephone) {
        this.companyTelephone = companyTelephone;
    }

    public String getDepositBank() {
        return depositBank;
    }

    public void setDepositBank(String depositBank) {
        this.depositBank = depositBank;
    }

    public String getBankAccount() {
        return bankAccount;
    }

    public void setBankAccount(String bankAccount) {
        this.bankAccount = bankAccount;
    }

    public String getInvoiceRemark() {
        return invoiceRemark;
    }

    public void setInvoiceRemark(String invoiceRemark) {
        this.invoiceRemark = invoiceRemark;
    }

    public String getDeliveryAddress() {
        return deliveryAddress;
    }

    public void setDeliveryAddress(String deliveryAddress) {
        this.deliveryAddress = deliveryAddress;
    }

    public String getInvoiceReceiver() {
        return invoiceReceiver;
    }

    public void setInvoiceReceiver(String invoiceReceiver) {
        this.invoiceReceiver = invoiceReceiver;
    }

    public String getReceivePhone() {
        return receivePhone;
    }

    public void setReceivePhone(String receivePhone) {
        this.receivePhone = receivePhone;
    }

    public Long getInvoiceAmount() {
        return invoiceAmount;
    }

    public void setInvoiceAmount(Long invoiceAmount) {
        this.invoiceAmount = invoiceAmount;
    }

    public Date getApplyDate() {
        return applyDate;
    }

    public void setApplyDate(Date applyDate) {
        this.applyDate = applyDate;
    }

    public Integer getInvoiceStatus() {
        return invoiceStatus;
    }

    public void setInvoiceStatus(Integer invoiceStatus) {
        this.invoiceStatus = invoiceStatus;
    }

    public String getCourierNumber() {
        return courierNumber;
    }

    public void setCourierNumber(String courierNumber) {
        this.courierNumber = courierNumber;
    }

    public String getRefuseReason() {
        return refuseReason;
    }

    public void setRefuseReason(String refuseReason) {
        this.refuseReason = refuseReason;
    }

    public Date getAutoConfirmInvoiceTime() {
        return autoConfirmInvoiceTime;
    }

    public void setAutoConfirmInvoiceTime(Date autoConfirmInvoiceTime) {
        this.autoConfirmInvoiceTime = autoConfirmInvoiceTime;
    }

    public Boolean getCanModifyCompanyName() {
        return canModifyCompanyName;
    }

    public void setCanModifyCompanyName(Boolean canModifyCompanyName) {
        this.canModifyCompanyName = canModifyCompanyName;
    }

    public Integer getCurMonthInvoiceNum() {
        return curMonthInvoiceNum;
    }

    public void setCurMonthInvoiceNum(Integer curMonthInvoiceNum) {
        this.curMonthInvoiceNum = curMonthInvoiceNum;
    }
}
