package cn.com.duiba.tuia.core.api.enums;

import org.apache.commons.lang.StringUtils;

/**
 * Created by huangch on 2018/3/25 18:13
 * description:
 *
 * @since JDK 1.6
 */
public enum AdvertDataSortEnum {
    consume("consume", "消耗排序"),
    ctr("ctr", "ctr值排序"),
    cvr("cvr", "cvr值排序"),
    arpu("arpu", "arpu值排序"),
    clickPrice("clickPrice", "点击成本排序");

    private String orderBy;
    private String desc;

    AdvertDataSortEnum(String orderBy, String desc) {
        this.orderBy = orderBy;
        this.desc = desc;
    }

    public static AdvertDataSortEnum getSort(String orderBy) {
        if (StringUtils.isBlank(orderBy)) {
            return null;
        }
        for (AdvertDataSortEnum sortEnum : values()) {
            if (orderBy.equals(sortEnum.getOrderBy())) {
                return sortEnum;
            }
        }
        return null;
    }

    public String getOrderBy() {
        return orderBy;
    }

    public String getDesc() {
        return desc;
    }
}
