package cn.com.duiba.tuia.core.api.utils;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import org.joda.time.DateTime;

import java.util.Date;
import java.util.List;

/**
 * Created by huangch on 2017/12/15 18:03
 * description:
 *
 * @since JDK 1.6
 */
public class TimeUtil {

    public static List<Integer> getMonthBetween(Date minDate, Date maxDate) {
        List<Integer> result = Lists.newArrayList();

        DateTime maxDateTime = new DateTime(maxDate);
        DateTime curDateTime = new DateTime(minDate);

        //防止死循环
        int maxForEachCount = 0;

        while (curDateTime.compareTo(maxDateTime) < 0 && maxForEachCount < 100) {
            result.add(curDateTime.getMonthOfYear());
            curDateTime = curDateTime.plusMonths(1);
            maxForEachCount++;
        }

        return result;
    }

    public static void main(String[] args) {
        System.out.println(JSON.toJSONString(getMonthBetween(DateTime.parse("2017-07-01").toDate(), DateTime.parse("2018-03-01").toDate())));
    }
}
