/**
 * Project Name:tuia-advert-center-api
 * File Name:RemoteAdvertAppOfflineDayService.java
 * Package Name:cn.com.duiba.tuia.core.api.remoteservice.appOffline
 * Date:2017年12月14日下午3:36:42
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.tuia.core.api.remoteservice.appOffline;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.req.appOffline.ReqAdvertAppShieldHourDto;
import cn.com.duiba.tuia.core.api.dto.rsp.appOffline.RspAdvertAppShieldHourDto;

/**
 * ClassName:RemoteAdvertAppOfflineDayService <br/>
 * Function: 实时每小时媒体屏蔽广告. <br/>
 * Date:     2017年12月14日 下午3:36:42 <br/>
 * @author   chencheng
 * @version  
 * @since    JDK 1.8
 * @see 	 
 */
@AdvancedFeignClient
public interface RemoteAdvertAppShieldHourService {
    /**
     * 
     * selectAdvertAppShieldHour:(查询实时每小时媒体屏蔽广告). <br/>
     *
     * @author chencheng
     * @param query
     * @return
     * @since JDK 1.8
     */
    List<RspAdvertAppShieldHourDto> selectAdvertAppShieldHour(ReqAdvertAppShieldHourDto query);
    
    /**
     * 
     * selectAdvertAppShieldMaxHour:(当日数据最新的小时). <br/>
     *
     * @author chencheng
     * @param curDate 当前日期
     * @return
     * @since JDK 1.8
     */
    Integer selectAdvertAppShieldMaxHour (String curDate);
}

