package cn.com.duiba.tuia.core.api.remoteservice.advertiser;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.AccountCheckRecordDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * Created by huangch on 2017/8/23 16:35
 * description:
 *
 * @since JDK 1.6
 */
@AdvancedFeignClient
public interface RemoteAccountCheckRecordService {

    /**
     * 添加广告主账号审核记录
     *
     * @param accountCheckRecord
     * @return
     */
    DubboResult<Integer> addCheckRecord(AccountCheckRecordDto accountCheckRecord);

    /**
     * 批量插入审核记录
     *
     * @param recordList
     * @return
     */
    DubboResult<Integer> batchInsertAccountCheckRecord(List<AccountCheckRecordDto> recordList);
    
    /**
     * 
     * selectAccountCheckRecordList:(查询审核记录). <br/>
     *
     * @author chencheng
     * @param AccountCheckRecordDto 查询条件
     * @return
     * @since JDK 1.8
     */
    List<AccountCheckRecordDto> selectAccountCheckRecordList(AccountCheckRecordDto accountCheckRecordDto);


    /**
     * 获取到该帐号最后一条审核记录
     * @param accountIds 帐号id列表
     * @return
     */
    List<AccountCheckRecordDto> selectLastRefuseCheckRecordList(List<Long> accountIds);
}
