package cn.com.duiba.tuia.core.api.enums.fincance;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

import java.util.List;
import java.util.Map;

/**充值类型定义
 * 线上充值 1
 * 线下转账 2
 * 退款扣除 3
 * 消耗调整 4
 * 季度返货 5
 * 账户迁移 6
 * 修偏 7
 * 季返扣除 8
 * 授信 9
 * 代理商划账 10
 * 其他 0
 * -1 未定义
 */
public enum BalanceRecordType {

                               // 记录类型： 充值
                               BALANCE_RECHARGE(10, "账号充值", "充值现金",-1),

                               BALANCE_RECHARGE_OFFLINE(101, "账号充值", "充值现金(线下转账)",2),

                               BALANCE_RECHARGE_ADJUST(102, "账号充值", "充值现金(消费调整)",4),

                               BALANCE_RECHARGE_MOVE(103, "账号充值", "充值现金(账户迁移)",6),

                               BALANCE_RECHARGE_FIX(104, "账号充值", "充值现金(修偏)",7),

                               BALANCE_RECHARGE_CREDIT(105, "账号充值", "充值现金(授信)",9),

                               BALANCE_RECHARGE_OTHER(106, "账号充值", "充值现金(其他)",0),

                               // 记录类型：代理商充值给广告主
                               BALANCE_RECHARGE_AD_IN(12, "代理商划账", "代理商划账(收入)",10),
                               BALANCE_RECHARGE_AD_IN_CASH(121, "代理商划账", "代理商划账(现金收入)",10),
                               BALANCE_RECHARGE_AD_IN_CASH_BACK(122, "代理商划账", "代理商划账(返货收入)",10),

                               // 记录类型： 充值返货.
                               BALANCE_PRESENT(13, "赠送金额", "充值返货",-1),

                               BALANCE_PRESENT_ONLINE(131, "赠送金额", "充值返货(线上充值)",1),

                               BALANCE_PRESENT_OFFLINE(132, "赠送金额", "充值返货(线下转账)",2),

                               BALANCE_PRESENT_ADJUST(133, "赠送金额", "充值返货(消费调整)",4),

                               BALANCE_PRESENT_BACK(134, "赠送金额", "充值返货(季度返货)",5),

                               BALANCE_PRESENT_MOVE(135, "赠送金额", "充值返货(账户迁移)",6),

                               BALANCE_PRESENT_FIX(136, "赠送金额", "充值返货(修偏)",7),

                               BALANCE_PRESENT_OTHER(137, "赠送金额", "充值返货(其他)",0),

                               // 记录类型：线上充值
                               BALANCE_THIRD_PARTY_RECHARGE(14, "在线充值", "代理商在线充值",1),

                               // 记录类型：消费修正充值
                               BALANCE_CONSUMER_CORRECTION_IN(15, "消费修正", "消费修正",-1),
                               BALANCE_CONSUMER_CORRECTION_IN_CASH(151, "消费修正", "消费修正(充值现金)",-1),
                               BALANCE_CONSUMER_CORRECTION_IN_CASH_BACK(152, "消费修正", "消费修正(充值返货)",-1),

                               // 记录类型：代理商回拨，代理商入账
                               BALANCE_CALL_BACK_AGENT_IN(16, "代理商回拨", "代理商回拨(收入)",-1),
                               BALANCE_CALL_BACK_AGENT_IN_CASH(161, "代理商回拨", "代理商回拨(现金收入)",-1),
                               BALANCE_CALL_BACK_AGENT_IN_CASH_BACK(162, "代理商回拨", "代理商回拨(返货收入)",-1),

                               // 记录类型：广告主(在线)充值
                               ADVERTISER_THIRD_PARTY_RECHARGE(17, "广告主充值", "广告主在线充值",1),

                               // 记录类型： 广告扣费
                               BALANCE_ADVERT_EXPEND(20, "广告扣费", "广告扣费",-1),

                               // 记录类型： 扣除金额(现金)
                               BALANCE_DEDUCTED(21, "扣除现金", "扣除金额",-1),

                               BALANCE_DEDUCTED_CASH(211, "扣除现金", "扣除现金(退款扣除)",3),

                               BALANCE_DEDUCTED_ADJUST(212, "扣除现金", "扣除现金(消费调整)",4),

                               BALANCE_DEDUCTED_MOVE(213, "扣除现金", "扣除现金(账户迁移)",6),

                               BALANCE_DEDUCTED_FIX(214, "扣除现金", "扣除现金(修偏)",7),

                               BALANCE_DEDUCTED_OTHER(215, "扣除现金", "扣除现金(其他)",0),

                               // 记录类型：代理商为广告主充值支出
                               BALANCE_RECHARGE_AGENT_OUT(22, "代理商划账", "代理商划账(支出)",10),
                               BALANCE_RECHARGE_AGENT_OUT_CASH(221, "代理商划账", "代理商划账(现金支出)",10),
                               BALANCE_RECHARGE_AGENT_OUT_CASH_BACK(222, "代理商划账", "代理商划账(返货支出)",10),

                               // 记录类型：消费修正扣费
                               BALANCE_CONSUMER_CORRECTION_OUT(24, "消费修正", "消费修正",-1),
                               BALANCE_CONSUMER_CORRECTION_OUT_CASH(241, "消费修正", "消费修正(扣除现金)",-1),
                               BALANCE_CONSUMER_CORRECTION_OUT_CASH_BACK(242, "消费修正", "消费修正(扣除返货)",-1),

                               // 记录类型：代理商回拨，广告主出账
                               BALANCE_CALL_BACK_AD_OUT(25, "代理商回拨", "代理商回拨(支出)",-1),
                               BALANCE_CALL_BACK_AD_OUT_CASH(251, "代理商回拨", "代理商回拨(现金支出)",-1),
                               BALANCE_CALL_BACK_AD_OUT_CASH_BACK(252, "代理商回拨", "代理商回拨(返货支出)",-1),

                               // 记录类型:扣除返货
                               BALANCE_DEDUCTED_CASH_BACK(26, "扣除返货", "扣除返货",-1),

                               DEDUCTED_CASH_BACK_REFUND(261, "扣除返货", "扣除返货(退款扣除)",3),

                               DEDUCTED_CASH_BACK_ADJUST(262, "扣除返货", "扣除返货(消费调整)",4),

                               DEDUCTED_CASH_BACK_MOVE(263, "扣除返货", "扣除返货(账户迁移)",6),

                               DEDUCTED_CASH_BACK_FIX(264, "扣除返货", "扣除返货(修偏)",7),

                               DEDUCTED_CASH_BACK_QUARTER(265, "扣除返货", "扣除返货(季返扣除)",8),

                               DEDUCTED_CASH_BACK_OTHER(266, "扣除返货", "扣除返货(其他)",0);

    private int    type;

    private String remark;

    private String detail;

    private int rechargeType;

    BalanceRecordType(int type, String remark, String detail, int rechargeType) {
        this.type = type;
        this.remark = remark;
        this.detail = detail;
        this.rechargeType = rechargeType;
    }

    private static Map<Integer, BalanceRecordType> enumMap = Maps.newHashMap();

    static {
        for (BalanceRecordType typeEnum : BalanceRecordType.values()) {
            enumMap.put(typeEnum.type, typeEnum);
        }
    }

    public static BalanceRecordType getByType(Integer type) {
        BalanceRecordType balanceRecordType = enumMap.get(type);
        if (balanceRecordType == null) {
            throw new BalanceRecordNonExistsException();
        }
        return balanceRecordType;
    }

    public static List<Integer> getRecordTypeListByRechargeType(Integer rechargeType) {
        List<Integer> recordTypeList = Lists.newArrayList();
        if (rechargeType == null) {
            return recordTypeList;
        }
        for (BalanceRecordType balanceRecordType : BalanceRecordType.values()) {
            int balanceRechargeType = balanceRecordType.getRechargeType();
            if (balanceRechargeType == rechargeType) {
                recordTypeList.add(balanceRecordType.getType());
            }
        }
        return recordTypeList;
    }

    private static class BalanceRecordNonExistsException extends RuntimeException {

        BalanceRecordNonExistsException() {
            super("不存在的财务记录类型");
        }
    }

    public static String getDetailByType(int type) {
        for (BalanceRecordType balanceRecordType : BalanceRecordType.values()) {
            if (balanceRecordType.getType() == type) {
                return balanceRecordType.getDetail();
            }
        }
        return "";
    }

    public String getDetail() {
        return detail;
    }

    public int getType() {
        return type;
    }

    public String getRemark() {
        return remark;
    }

    public int getRechargeType() {
        return rechargeType;
    }

}
