package cn.com.duiba.tuia.core.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.PageDto;
import cn.com.duiba.tuia.core.api.dto.PrivilegeAdvertDto;
import cn.com.duiba.tuia.core.api.dto.req.ReqPageQueryPrivilegeAdvert;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * Created by lizhihui on 2017-05-26 13:41.
 * 管理端特权广告相关操作api
 */
@AdvancedFeignClient
public interface RemotePrivilegeAdvertService {


    /**
     * 分页查询特权广告列表
     *
     * @param query 查询条件
     * @return 特权广告列表
     */
    DubboResult<PageDto<PrivilegeAdvertDto>> pageQuery(ReqPageQueryPrivilegeAdvert query);


    /**
     * 增加特权广告
     *
     * @param advertId 广告id
     * @return 是否添加成功
     */
    DubboResult<Boolean> add(Long advertId);

    /**
     * 移除特权广告
     *
     * @param advertId 广告
     * @return 是否删除成功
     */
    DubboResult<Boolean> remove(Long advertId);

    /**
     * 获取 根据广告id获取简单信息
     *
     * @param advertId 广告信息
     */
    DubboResult<PrivilegeAdvertDto> getById(Long advertId);
}
