package cn.com.duiba.tuia.core.api.enums;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang.StringUtils;

/**
 * 新媒体流量策略配置位运算开关 date: 2017年4月17日 下午2:17:12 <br/>
 *
 * @author chencheng
 * @version
 */
public enum AppFlowStrategyValidPeriodHourEnum {
    /** 1. */
    Hour_1("00", 1),

    /** 2. */
    Hour_2("02", 2),

    /** 3. */
    Hour_3("04", 3),

    /** 4. */
    Hour_4("06", 4),

    /** 5. */
    Hour_5("08", 5),

    /** 6. */
    Hour_6("10", 6),

    /** 7. */
    Hour_7("12", 7),

    /** 8. */
    Hour_8("14", 8),

    /** 9. */
    Hour_9("16", 9),

    /** 10. */
    Hour_10("18", 10),

    /** 11. */
    Hour_11("20", 11),

    /** 12. */
    Hour_12("22", 12),

    /** 13. */
    Hour_13("24", 13);

    /** 代码 */
    private String code;
    /** 描述 */
    private int    desc;
    
    private List<String> list;

    private AppFlowStrategyValidPeriodHourEnum(String code, int desc) {
        this.code = code;
        this.desc = desc;
    }

    public static AppFlowStrategyValidPeriodHourEnum getByCode(String code) {
        for (AppFlowStrategyValidPeriodHourEnum enumVal : AppFlowStrategyValidPeriodHourEnum.values()) {
            if (StringUtils.equals(code, enumVal.getCode())) {
                return enumVal;
            }
        }
        return null;
    }
    
    public static String getByDesc(int desc) {
        for (AppFlowStrategyValidPeriodHourEnum enumVal : AppFlowStrategyValidPeriodHourEnum.values()) {
            if (desc == enumVal.getDesc()) {
                return enumVal.getCode();
            }
        }
        return null;
    }

    public static List<String> getAll(){
        List<String> list = new ArrayList<String>();
        for (AppFlowStrategyValidPeriodHourEnum enumVal : AppFlowStrategyValidPeriodHourEnum.values()) {
            list.add(enumVal.getCode());
        }
        return list;
    }
    /**
     * code.
     *
     * @return the code
     */
    public String getCode() {
        return code;
    }



    /**
     * desc.
     *
     * @return the desc
     */
    public int getDesc() {
        return desc;
    }


    
    /**
     * list.
     *
     * @return  the list
     */
    public List<String> getList() {
        if (list == null) {
            this.list = getAll();
        }
        return list;
    }

}
