package cn.com.duiba.tuia.core.api.enums.advert;

import org.apache.commons.lang.StringUtils;

/**广告-定向配置包-投放时段
 * Created by zhengjy on 2017/7/20.
 */
public enum AdvertPkgPeriodTypeEnum {
    /** 每小时预算. */
    PERIOD_TYPE_HOUR_BUDGET("hourBudget","每小时预算"),
    /** 总预算. */
    PERIOD_TYPE_COUNT_BUDGET("countBudget","总预算"),
    /** 每小时发券. */
    PERIOD_TYPE_HOUR_COUPON("hourCoupon","每小时发券"),
    /** 总发券 . */
    PERIOD_TYPE_COUNT_COUPON("countCoupon","总发券"),

    ;

    /** 代码 */
    private String code;
    /** 描述 */
    private String desc;

    private AdvertPkgPeriodTypeEnum(String code, String desc){
        this.code = code;
        this.desc = desc;
    }

    public static AdvertPkgPeriodTypeEnum getByCode(String code){
        for(AdvertPkgPeriodTypeEnum enumVal : AdvertPkgPeriodTypeEnum.values()){
            if(StringUtils.equals(code,enumVal.getCode())){
                return enumVal;
            }
        }
        return null;
    }

    public String getCode() {
        return code;
    }


    public String getDesc() {
        return desc;
    }

}
