package cn.com.duiba.tuia.core.api.remoteservice.app;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.app.AdvertDataDto;
import cn.com.duiba.tuia.core.api.dto.app.AppWhiteDataDto;
import cn.com.duiba.tuia.core.api.dto.app.IdAndAmountDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * Created by huangch on 2017/8/29 17:25
 * description:
 *
 * @since JDK 1.6
 */
@AdvancedFeignClient
public interface RemoteAppWhiteListService {

    /**
     * 根据appIds批量查询绑定的广告计划数量.
     *
     * @param appIds     the app ids
     * @param strategyId
     * @return the list< integer>
     */
    DubboResult<List<IdAndAmountDto>> selectAmountByAppIds(List<Long> appIds, Long strategyId, String type);

    /**
     * 通过appId和策略id查询绑定的广告计划.
     * 策略id是新媒体流量策略定制时传递
     *
     * @param appId      the app id
     * @param strategyId
     * @param type
     * @return the list< app white data d o>
     */
    DubboResult<List<AppWhiteDataDto>> selectWhiteListByAppId(Long appId, Long strategyId, String type);

    /**
     * 查询默认白名单和新的白名单
     * @param appId
     * @param type
     * @return
     */
    List<AppWhiteDataDto> selectWhiteListByAppIdAndType(Long appId, String type);


    /**
     * 只通过appId查询
     * @param appId
     * @return
     */
    DubboResult<List<AppWhiteDataDto>> selectWhiteListByOnlyAppId(Long appId);

    /**
     * 通过appId、广告Id和策略Id查询app绑定的广告.
     * 策略id是新媒体流量策略定制时传递
     *
     * @param appId      the app id
     * @param advertId   the advert id
     * @param strategyId
     * @param type
     * @return the app white data do
     */
    DubboResult<AppWhiteDataDto> selectByAppIdAndAdvertId(Long appId, Long advertId, Long strategyId, String type);

    /**
     * 删除一条app绑定的广告记录.
     *
     * @param id the id
     * @return the int
     */
    DubboResult<Integer> delete(Long id);

    /**
     * 绑定app与广告.
     *
     * @param appId      the app id
     * @param advertId   the advert id
     * @param orderLevel the order level
     * @param strategyId
     * @param type
     * @return the int
     */
    DubboResult<Integer> bindAdvert(Long appId, Long advertId, Integer orderLevel, Long strategyId, String type);

    /**
     * 查询该app下的最大排序序号.
     *
     * @param appId      the app id
     * @param strategyId
     * @param type
     * @return the integer
     */
    DubboResult<Integer> selectMaxOrderLevel(Long appId, Long strategyId, String type);

    /**
     * 查询该app下的最小排序序号.
     *
     * @param appId      the app id
     * @param strategyId
     * @param type
     * @return the integer
     */
    DubboResult<Integer> selectMinOrderLevel(Long appId, Long strategyId, String type);

    /**
     * 更新该广告在此媒体中的排序.
     *
     * @param id         the id
     * @param orderLevel the order level
     */
    DubboResult<Integer> updateOrder(Long id, Integer orderLevel);

    /**
     * 给该媒体应用下orderLevel大于修改排序的广告排序.
     *
     * @param appID      the app id
     * @param orderLevel the order level
     * @param strategyId
     * @param type
     */
    DubboResult<Integer> updateBindOrder(Long appID, Integer orderLevel, Long strategyId, String type);

    /**
     * 如果广告被删除则删除app和广告的关联关系.
     *
     * @param adverts the adverts
     */
    DubboResult<Integer> deleteByAdvertIds(List<Long> adverts);

    /**
     * 流量策略获取广告列表
     * @param slotId
     * @param appId
     * @param strategyId
     * @param advertId
     * @param type
     * @return
     */
    List<AdvertDataDto> getAdvertList(Long slotId, Long appId, Long strategyId, Long advertId, String type);
}
