/**
 * Project Name:tuia-core-api<br>
 * File Name:AdvertDuibaItemDto.java<br>
 * Package Name:cn.com.duiba.tuia.core.api.dto<br>
 * Date:2016年11月9日下午12:33:22<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.core.api.dto;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * ClassName: AdvertDuibaItemDto <br/>
 * Function: 推啊广告和兑吧兑换项关联 dto. <br/>
 * date: 2016年11月9日 下午12:33:22 <br/>
 *
 * @author guyan
 * @version
 * @since JDK 1.6
 */
public class AdvertDuibaItemDto extends BaseDto {

    /** 序列号. */
    private static final long serialVersionUID     = -2892553158521987728L;

    /** 关联状态-关联. */
    public static final int   RELATION_STATE_TRUE  = 1;

    /** 关联状态-取消关联. */
    public static final int   RELATION_STATE_FALSE = 0;

    /** 广告ID. */
    private Long              advertId;

    /** 兑换项ID. */
    private Long              itemId;

    /** 兑换项名称. */
    private String            itemName;

    /** 关联状态 1:关联， 0:取消关联. */
    private Integer           relationState;
    
    /** 生效时间. */
    private String            effectiveTime;

    public String getEffectiveTime() {
        return effectiveTime;
    }

    public void setEffectiveTime(String effectiveTime) {
        this.effectiveTime = effectiveTime;
    }

    /**
     * Gets the advert id.
     *
     * @return the advert id
     */
    public Long getAdvertId() {
        return advertId;
    }

    /**
     * Sets the advert id.
     *
     * @param advertId the advert id
     */
    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    /**
     * Gets the item id.
     *
     * @return the item id
     */
    public Long getItemId() {
        return itemId;
    }

    /**
     * Sets the item id.
     *
     * @param itemId the item id
     */
    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    /**
     * Gets the item name.
     *
     * @return the item name
     */
    public String getItemName() {
        return itemName;
    }

    /**
     * Sets the item name.
     *
     * @param itemName the item name
     */
    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    /**
     * Gets the relation state.
     *
     * @return the relation state
     */
    public Integer getRelationState() {
        return relationState;
    }

    /**
     * Sets the relation state.
     *
     * @param relationState the relation state
     */
    public void setRelationState(Integer relationState) {
        this.relationState = relationState;
    }

    /**
     * To string.
     *
     * @return the string
     */
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
