package cn.com.duiba.tuia.core.api.remoteservice.advert;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.advert.AdvertRuleDto;
import cn.com.duiba.tuia.core.api.dto.advert.req.ReqAdvertRuleDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * Created by huangch on 2017/8/24 17:26
 * description:
 *
 * @since JDK 1.6
 */
@AdvancedFeignClient
public interface RemoteAdvertRuleService {

    /**
     * 记录广告规则
     *
     * @param advertRule 广告规则
     * @since JDK 1.6
     */
    DubboResult<Integer> insertAdvertRule(AdvertRuleDto advertRule);

    /**
     * 查询广告规则. <br/>
     *
     * @param req 请求参数
     * @return 广告规则列表
     * @since JDK 1.6
     */
    DubboResult<List<AdvertRuleDto>> selectAdvertRule(ReqAdvertRuleDto req);

    /**
     * 根据标签查询广告规则. <br/>
     *
     * @param tags 标签
     * @return 广告规则列表
     * @since JDK 1.6
     */
    DubboResult<List<AdvertRuleDto>> selectAdvertRuleByTags(String tags);

    /**
     * 软删指定广告规则
     *
     * @param req 请求参数
     * @since JDK 1.6
     */
    DubboResult<Integer> updateAdvertRuleStatus(ReqAdvertRuleDto req);
}
