package cn.com.duiba.tuia.core.api.dto.resourceTags;

import org.apache.commons.lang.builder.ToStringBuilder;

import cn.com.duiba.tuia.core.api.dto.BaseDto;

/**
 * ClassName: ResoureTagsDO <br/>
 * Function: 资源对应标签. <br/>
 * date: 2017年7月31日 下午4:38:40 <br/>
 *
 * @author chencheng
 * @version
 */
public class ResourceTagsDto extends BaseDto {

    private static final long serialVersionUID = -6749723687994482437L;

    /** 广告id或素材id */
    private Long              resourceId;

    /** 来源类型：ad(广告推广链接)，material(素材) @{ResourceTagsTypeEnum} */
    private String            resourceType;

    /** 标签编号，多个标签用逗号相隔 */
    private String            tagNums;

    /**
     * resourceId.
     *
     * @return the resourceId
     */
    public Long getResourceId() {
        return resourceId;
    }

    /**
     * resourceId.
     *
     * @param resourceId the resourceId to set
     */
    public void setResourceId(Long resourceId) {
        this.resourceId = resourceId;
    }

    /**
     * resourceType.
     *
     * @return the resourceType
     */
    public String getResourceType() {
        return resourceType;
    }

    /**
     * resourceType.
     *
     * @param resourceType the resourceType to set
     */
    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    /**
     * tagNums.
     *
     * @return the tagNums
     */
    public String getTagNums() {
        return tagNums;
    }

    /**
     * tagNums.
     *
     * @param tagNums the tagNums to set
     */
    public void setTagNums(String tagNums) {
        this.tagNums = tagNums;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
