package cn.com.duiba.tuia.core.api.remoteservice.advert;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * Created by huangch on 2017/8/23 15:01
 * description:
 *
 * @since JDK 1.6
 */
@AdvancedFeignClient
public interface RemoteAdvertConsumeCurrentService {

    /**
     * 获取广告主总当天总的消费金额.
     *
     * @param accountId 广告主ID
     * @return 广告主总当天总的消费金额
     */
    DubboResult<Long> getTotalFeeByAccountId(Long accountId);

    /**
     * 获取广告总当天总的消费金额.
     *
     * @param advertId 广告ID
     * @return 当天总的消费金额
     */
    DubboResult<Long> getTotalFeeByAdvertId(Long advertId);
}
