package cn.com.duiba.tuia.core.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.GlobalFlowConfigDto;
import cn.com.duiba.tuia.core.api.dto.rsp.tag.NewTagLevelDto;

import java.util.List;
import java.util.Map;

/**
 * @Author:zhangmeng
 * @Date:2018-06-11
 * @Function:操作全局配置流量
 */
@AdvancedFeignClient
public interface RemoteGlobalFlowConfigService {
    /**
     * 查询所有的全局流量配置规则
     */
    List<GlobalFlowConfigDto> queryAll();

    /**
     * 通过id查询全局流量配置
     */
    GlobalFlowConfigDto queryGlobalFlowConfigById(Long id);

    /**
     * 保存全局流量配置
     */
    Integer save(GlobalFlowConfigDto globalFlowConfigDto);

    /**
     * 删除全局流量配置
     */
     Integer delete(GlobalFlowConfigDto globalFlowConfigDto);
    /**
     * 获取落地页和广告标签
     */
    List<NewTagLevelDto> queryLandPageAndAdvertTags();

    /**
     * 校验配置是否存在
     */
    Integer queryGlobalFlowConfigCount(GlobalFlowConfigDto globalFlowConfigDto);

    /**
     * 获取广告下的定向配置命中规则并发生替换
     */
    List<GlobalFlowConfigDto> getHitOrientation(Map<String,Object> map);

    /**
     * 获取最后一条被操作的全局流量规则
     */
    GlobalFlowConfigDto getLastGlobalFlowConfigItem();
}
