package cn.com.duiba.tuia.core.api.remoteservice;


import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.req.ReqAdvertCorrectionDto;
import cn.com.duiba.tuia.core.api.dto.rsp.advert.AdvertConsumerCorrectionDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * @author: <a href="http://www.panaihua.com">panaihua</a>
 * @date: 2017年05月16日 15:31
 * @descript:
 * @version: 1.0
 */
@AdvancedFeignClient
public interface RemoteAdvertCorrectionService {

    /**
     * 消费修正
     * @param advertCorrectionDto
     * @return
     */
    DubboResult<Boolean> updateConsumerCorrections(ReqAdvertCorrectionDto advertCorrectionDto);

    /**
     * 获取是否已经有消费修正
     * @param advertCorrectionDto
     * @return
     */
    DubboResult<Set<Date>> getConsumerCorrections(ReqAdvertCorrectionDto advertCorrectionDto);

    /**
     * 获取广告列表的汇总修正消费
     * @param advertIds
     * @return
     */
    DubboResult<Map<Long,BigDecimal>> getAdvertCorrection(List<Long> advertIds,Date beginTime,Date endTime);
    
    /**
     * 获取广告列表的详细分日修正消费
     * @param advertIds
     * @return
     */
    DubboResult<List<AdvertConsumerCorrectionDto>> getAdvertCurDateCorrection(List<Long> advertIds,Date beginTime,Date endTime);
}
