/**
 * Project Name:manager-domain File Name:GetAppDataReq.java Package Name:cn.com.duiba.tuia.manager.req
 * Date:2016年5月25日下午4:48:23 Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.core.api.dto.req.data;

import java.io.Serializable;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * ClassName: ReqAdvertDiffentWayData <br/>
 * Function: 广告不同发券方式统计数据查询参数. <br/>
 * date: 2018年5月31日 下午5:06:39 <br/>
 *
 * @author chencheng
 * @version
 * @since JDK 1.8
 */
public class ReqAdvertDiffentWayData implements Serializable {

    private static final long serialVersionUID = -2563750625868073668L;

    /** 开始日期. */
    private String            startDate;

    /** 结束日期. */
    private String            endDate;

    /** 广告ID */
    private Long              advertId;

    /** 活动类型：0-互动广告，1-展示广告 */
    private Integer           activityType;

    /**
     * startDate.
     *
     * @return the startDate
     * @since JDK 1.8
     */
    public String getStartDate() {
        return startDate;
    }

    /**
     * startDate.
     *
     * @param startDate the startDate to set
     * @since JDK 1.8
     */
    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    /**
     * endDate.
     *
     * @return the endDate
     * @since JDK 1.8
     */
    public String getEndDate() {
        return endDate;
    }

    /**
     * endDate.
     *
     * @param endDate the endDate to set
     * @since JDK 1.8
     */
    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    /**
     * advertId.
     *
     * @return the advertId
     * @since JDK 1.8
     */
    public Long getAdvertId() {
        return advertId;
    }

    /**
     * advertId.
     *
     * @param advertId the advertId to set
     * @since JDK 1.8
     */
    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    /**
     * activityType.
     *
     * @return the activityType
     * @since JDK 1.8
     */
    public Integer getActivityType() {
        return activityType;
    }

    /**
     * activityType.
     *
     * @param activityType the activityType to set
     * @since JDK 1.8
     */
    public void setActivityType(Integer activityType) {
        this.activityType = activityType;
    }

    /**
     * To string.
     *
     * @return the string
     * @see Object#toString()
     */
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
