/**
 * Project Name:tuia-core-api<br>
 * File Name:AppDto.java<br>
 * Package Name:cn.com.duiba.tuia.core.api.dto<br>
 * Date:2016年12月9日下午4:35:19<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.core.api.dto.req.app;

import java.util.List;

import org.apache.commons.lang.builder.ToStringBuilder;

import cn.com.duiba.tuia.core.api.dto.BaseQueryDto;

/**
 * 新媒体策略配置查询请求 
 * date: 2017年4月14日 下午2:50:24 <br/>
 *
 * @author chencheng
 * @version
 */
public class ReqAppFlowStrategyDto extends BaseQueryDto {

    private static final long serialVersionUID = -532816154419384458L;

    /** 应用id集合. */
    private List<Long>        appIds;

    /** 新媒体流量策略类型,0:关闭，1:暂停 */
    private Integer           appFlowStrategyType;
    
    /** 媒体策略状态列表 */
    private List<Integer>     switchesList;

    /**
     * switchesList.
     *
     * @return  the switchesList
     */
    public List<Integer> getSwitchesList() {
        return switchesList;
    }
    
    /**
     * switchesList.
     *
     * @param   switchesList    the switchesList to set
     */
    public void setSwitchesList(List<Integer> switchesList) {
        this.switchesList = switchesList;
    }

    /**
     * appIds.
     *
     * @return  the appIds
     */
    public List<Long> getAppIds() {
        return appIds;
    }

    /**
     * appIds.
     *
     * @param   appIds    the appIds to set
     */
    public void setAppIds(List<Long> appIds) {
        this.appIds = appIds;
    }

    /**
     * appFlowStrategyType.
     *
     * @return the appFlowStrategyType
     */
    public Integer getAppFlowStrategyType() {
        return appFlowStrategyType;
    }

    /**
     * appFlowStrategyType.
     *
     * @param appFlowStrategyType the appFlowStrategyType to set
     */
    public void setAppFlowStrategyType(Integer appFlowStrategyType) {
        this.appFlowStrategyType = appFlowStrategyType;
    }

    /**
     * To string.
     *
     * @return the string
     */
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
