/**
 * Project Name:tuia-core-api<br>
 * File Name:RemoteTagBackendService.java<br>
 * Package Name:cn.com.duiba.tuia.core.api.remoteservice<br>
 * Date:2016年9月27日下午7:17:10<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.core.api.remoteservice;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.TagDto;
import cn.com.duiba.tuia.core.api.dto.TagLevel;
import cn.com.duiba.tuia.core.api.enums.TagsNumEnum;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName: RemoteTagBackendService <br/>
 * Function: 标签. <br/>
 * date: 2016年9月27日 下午7:17:10 <br/>
 *
 * @author leiliang
 * @version
 * @since JDK 1.6
 */
@AdvancedFeignClient
public interface RemoteTagBackendService {

    /**
     * 查询所有标签.
     *
     * @return the all tags
     */
    DubboResult<List<TagLevel>> getAllTags();

    /**
     * 查询广告标签库.
     *
     * @return the industries
     */
    DubboResult<List<TagLevel>> getAdvertTagLibrary();

    /**
     * 查询屏蔽标签库.
     *
     * @return the all industries
     */
    DubboResult<List<TagLevel>> getBannedTagLibrary();

    /**
     * 查询活动标签库.
     *
     * @return the all industries
     */
    DubboResult<List<TagLevel>> getActivityTagLibrary();
    
    /**
     * 根据类型查询标签库. @{TagsNumEnum}
     *
     * @return the all industries
     */
    DubboResult<List<TagLevel>> getTagsLibraryByType(TagsNumEnum type);

    /**
     * 新增标签.
     *
     * @param name 标签(分类)名称
     * @param level 级别
     * @param parentTagNum the parent tag num
     * @return the dubbo result< tag dto>
     */
    DubboResult<String> addTag(String name, int level, String parentTagNum);

    /**
     * 标签定位接口.
     *
     * @param name 标签名称
     * @return 标签ID列表
     */
    DubboResult<List<String>> getNumsByName(String name);

    /**
     * 模糊查询所有匹配的标签(根据标签名去重).
     *
     * @param name the name
     * @return the dubbo result< list< tag dto>>
     */
    DubboResult<List<TagDto>> getListGroupByName(String name);

    /**
     * 清除标签库缓存.
     *
     * @return the dubbo result< list< tag dto>>
     */
    DubboResult<Boolean> cleanTagLibraryCache();

    /**
     * 批量查询标签信息.
     *
     * @param tagNums the tag nums
     * @return the all tags
     */
    DubboResult<List<TagDto>> getListByNums(List<String> tagNums);

    /**
     * 获取列表
     * @param ids
     * @return
     */
    DubboResult<List<TagDto>> getByTagIds(List<Long> ids);

    /**
     * selectDuplicationTagName:(同级标签下重名标签). <br/>
     *
     * @author chencheng
     * @param parentNum 父标签tag_num
     * @param tagName 标签名称
     * @return
     * @since JDK 1.8
     */
    Boolean selectDuplicationTagName(String parentNum, String tagName);
    
    /**
     * 
     * updateTag:(更新标签). <br/>
     *
     * @author chencheng
     * @param tagDto
     * @return
     * @since JDK 1.8
     */
    Integer batchUpdateTag(List<TagDto> list);
    
    /**
     * 批量查询标签信息.
     *
     * @param tagNums the tag nums
     * @return the all tags
     */
    List<TagDto> getOldAndNewTagsByNums(List<String> tagNums);
}
