/**
 * Project Name:tuia-core-api<br>
 * File Name:InsertCouponFileDto.java<br>
 * Package Name:cn.com.duiba.tuia.core.api.dto<br>
 * Date:2016年8月19日下午4:56:48<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.core.api.dto.rsp;

import java.io.Serializable;

/**
 * ClassName: InsertCouponFileDto <br/>
 * Function: 优惠码数据导入结果. <br/>
 * date: 2016年8月19日 下午4:56:48 <br/>
 *
 * @author leiliang
 * @version
 * @since JDK 1.6
 */
public class RspInsertCouponFileDto implements Serializable {

    private static final long serialVersionUID = 1L;

    /** 成功导入数据条数. */
    private String            addCount;

    /** 导入失败（重复）数据条数. */
    private String            repeatCount;

    /** 导入券码记录ID. */
    private Long              goodsBatchImportLogId;

    /** 是否导入完成 */
    private boolean           isImportFinished;

    public String getAddCount() {
        return addCount;
    }

    public void setAddCount(String addCount) {
        this.addCount = addCount;
    }

    public String getRepeatCount() {
        return repeatCount;
    }

    public void setRepeatCount(String repeatCount) {
        this.repeatCount = repeatCount;
    }

    public Long getGoodsBatchImportLogId() {
        return goodsBatchImportLogId;
    }

    public void setGoodsBatchImportLogId(Long goodsBatchImportLogId) {
        this.goodsBatchImportLogId = goodsBatchImportLogId;
    }

    public boolean isImportFinished() {
        return isImportFinished;
    }

    public void setImportFinished(boolean isImportFinished) {
        this.isImportFinished = isImportFinished;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("InsertCouponFileDto [addCount=");
        builder.append(addCount);
        builder.append(", repeatCount=");
        builder.append(repeatCount);
        builder.append(", goodsBatchImportLogId=");
        builder.append(goodsBatchImportLogId);
        builder.append(", isImportFinished=");
        builder.append(isImportFinished);
        builder.append("]");
        return builder.toString();
    }

}
