package cn.com.duiba.tuia.core.api.remoteservice.risk;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.risk.TagBaseDto;
import cn.com.duiba.tuia.core.api.dto.risk.TagsItemDto;

import java.util.List;
import java.util.Map;

/**
 * Created by huangch on 2018/4/26 14:03
 * description: 给风控(钟馗)提供需要的接口
 *
 * @since JDK 1.6
 */
@AdvancedFeignClient
public interface RemoteRiskControlService {

    /**
     * 查询所有的广告行业标签(一级行业标签)
     *
     * @return tagNum&tagName
     */
    List<TagBaseDto> queryAdvertIndustryTagList();

    /**
     * 查询所有的广告落地页标签(二级标签)
     *
     * @return tagNum&tagName
     */
    List<TagBaseDto> queryAdvertLandPageTagList();

    /**
     * 广告复审结果处理
     *
     * @param advertIds        复审的广告id集合——必传
     * @param reviewResultType 复审结果类型，1-复审通过，2-复审拒绝——必传
     * @param refuseReason     复审时的拒绝原因——reviewResultType=2时必传
     * @return 处理成功or失败
     */
    Boolean advertReviewResultHandle(List<Long> advertIds, Integer reviewResultType, String refuseReason);

    /**
     * 广告巡检结果处理
     *
     * @param advertIds         巡检的广告id集合——必传
     * @param inspectResultType 巡检结果类型，1-巡检通过，2-巡检拒绝，3-巡检下线——必传
     * @param refuseReason      巡检时的拒绝原因——inspectResultType=2时必传
     * @return 处理成功or失败
     */
    Boolean advertInspectResultHandle(List<Long> advertIds, Integer inspectResultType, String refuseReason);

    /**
     * 通过广告id，查询对应的行业，落地页，属性，
     */
    Map<Long,List<TagsItemDto>> getTagsByAdvertId(List<Long> ids);
}
