package cn.com.duiba.tuia.core.api.remoteservice.statistics;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.statistics.AdvertAlgDiagnosticMergeOutDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * Created by huangch on 2017/9/18 15:30
 * description:
 *
 * @since JDK 1.6
 */
@AdvancedFeignClient
public interface RemoteAdvertDiagnosticService {

    /**
     * 根据广告id和诊断的数据日期查询数据
     *
     * @param advertIds 查询的广告id列表
     * @param curDate   诊断的数据日期
     * @return list
     */
    DubboResult<List<AdvertAlgDiagnosticMergeOutDto>> selectByAdvertIdsAndDt(List<Long> advertIds, String curDate);
}
