/**
 * Project Name:tuia-advert-center-api
 * File Name:SocietyTagUserCountDto.java
 * Package Name:cn.com.duiba.tuia.core.api.dto.rsp.tagUserCount
 * Date:2018年3月21日下午5:36:53
 * Copyright (c) 2018, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.tuia.core.api.dto.rsp.tagUserCount;

import java.io.Serializable;
import java.util.Date;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * ClassName:SocietyTagUserCountDto <br/>
 * Function: 社会属性标签用户数统计. <br/>
 * Date:     2018年3月21日 下午5:36:53 <br/>
 * @author   chencheng
 * @version  
 * @since    JDK 1.8
 * @see 	 
 */
public class SocietyTagUserCountDto implements Serializable {
    
    private static final long serialVersionUID = -111384516298592559L;

    /** 时间 */
    private Date              curDate;

    /** 社会属性标签:health(健康养生),shopping(购物),finance(金融理财),poker(棋牌游戏),biggame(大型游戏) */
    private String            tag;

    /** 去重用户数uv */
    private Long              uv;

    
    public SocietyTagUserCountDto() {
        super();
    }


    /**
     * curDate.
     *
     * @return  the curDate
     * @since   JDK 1.8
     */
    public Date getCurDate() {
        return curDate;
    }

    
    /**
     * curDate.
     *
     * @param   curDate    the curDate to set
     * @since   JDK 1.8
     */
    public void setCurDate(Date curDate) {
        this.curDate = curDate;
    }

    
    /**
     * tag.
     *
     * @return  the tag
     * @since   JDK 1.8
     */
    public String getTag() {
        return tag;
    }

    
    /**
     * tag.
     *
     * @param   tag    the tag to set
     * @since   JDK 1.8
     */
    public void setTag(String tag) {
        this.tag = tag;
    }

    
    /**
     * uv.
     *
     * @return  the uv
     * @since   JDK 1.8
     */
    public Long getUv() {
        return uv;
    }

    
    /**
     * uv.
     *
     * @param   uv    the uv to set
     * @since   JDK 1.8
     */
    public void setUv(Long uv) {
        this.uv = uv;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
    
}

