/**
 * Project Name:tuia-advert-center-api
 * File Name:BannedAppFlowTypeEnum.java
 * Package Name:cn.com.duiba.tuia.core.api.enums
 * Date:2018年3月16日上午9:34:07
 * Copyright (c) 2018, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.tuia.core.api.enums;

import java.util.Map;

import com.google.common.collect.Maps;

/**
 * 
 * ClassName: BannedAppFlowTypeEnum <br/>
 * Function: 定向配置包——屏蔽流量类型. <br/>
 * date: 2018年1月29日 下午2:51:23 <br/>
 *
 * @author chencheng
 * @version 
 * @since JDK 1.8
 */
public enum BannedAppFlowTypeEnum {

    /** 微信-android*/
    WECHAT_ANDROID("1.1", "微信-android"),
    
    /** 微信-ios */
    WECHAT_IOS("1.2", "微信-ios"),
    
    /** QQ-android */
    QQ_ANDROID("2.1", "QQ-android"),
    
    /** 推广链接标签 */
    QQ_IOS("2.2", "QQ-ios"),

    /** 支付宝-android */
    ALIPAY_ANDROID("3.1", "支付宝-android"),
    
    /** 支付宝-ios */
    ALIPAY_IOS("3.2", "支付宝-ios");

    private String desc;

    private String code;

    BannedAppFlowTypeEnum(String code, String desc) {
        this.desc = desc;
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public String getCode() {
        return code;
    }

    private static Map<String, BannedAppFlowTypeEnum> enumMap = Maps.newHashMap();
    static {
        for (BannedAppFlowTypeEnum it : BannedAppFlowTypeEnum.values()) {
            enumMap.put(it.getCode(), it);
        }
    }

    public static BannedAppFlowTypeEnum getByName(String code) {
        return enumMap.get(code);
    }
}


