/**
 * Project Name:tuia-advert-web-domain File Name:QualificationRsp.java Package Name:cn.com.duiba.tuia.domain.model.rsp
 * Date:2017年11月27日上午10:54:08 Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.core.api.dto.rsp.account;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import org.apache.commons.lang.builder.ToStringBuilder;

import cn.com.duiba.tuia.core.api.dto.BaseDto;

/**
 * ClassName:QualificationRsp <br/>
 * Function: 代理商层级关系. <br/>
 * Date: 2017年11月27日 上午10:54:08 <br/>
 * 
 * @author chencheng
 * @version
 * @since JDK 1.8
 * @see
 */
@ApiModel("代理商层级关系")
public class AccountLevelDto extends BaseDto {

    private static final long serialVersionUID = -5690381647071644576L;

    /** 一级代理商公司名称. */
    @ApiModelProperty("一级代理商公司名称.")
    private String            oneLevelAgentName;

    /** 二级代理商公司名称. */
    @ApiModelProperty("二级代理商公司名称.")
    private String            twoLevelAgentName;

    /** 三级代理商公司名称. */
    @ApiModelProperty("三级代理商公司名称.")
    private String            threeLevelAgentName;

    /** 四级代理商公司名称. */
    @ApiModelProperty("四级代理商公司名称.")
    private String            fourLevelAgentName;

    /**
     * oneLevelAgentName.
     *
     * @return the oneLevelAgentName
     * @since JDK 1.8
     */
    public String getOneLevelAgentName() {
        return oneLevelAgentName;
    }

    /**
     * oneLevelAgentName.
     *
     * @param oneLevelAgentName the oneLevelAgentName to set
     * @since JDK 1.8
     */
    public void setOneLevelAgentName(String oneLevelAgentName) {
        this.oneLevelAgentName = oneLevelAgentName;
    }

    /**
     * twoLevelAgentName.
     *
     * @return the twoLevelAgentName
     * @since JDK 1.8
     */
    public String getTwoLevelAgentName() {
        return twoLevelAgentName;
    }

    /**
     * twoLevelAgentName.
     *
     * @param twoLevelAgentName the twoLevelAgentName to set
     * @since JDK 1.8
     */
    public void setTwoLevelAgentName(String twoLevelAgentName) {
        this.twoLevelAgentName = twoLevelAgentName;
    }

    /**
     * threeLevelAgentName.
     *
     * @return the threeLevelAgentName
     * @since JDK 1.8
     */
    public String getThreeLevelAgentName() {
        return threeLevelAgentName;
    }

    /**
     * threeLevelAgentName.
     *
     * @param threeLevelAgentName the threeLevelAgentName to set
     * @since JDK 1.8
     */
    public void setThreeLevelAgentName(String threeLevelAgentName) {
        this.threeLevelAgentName = threeLevelAgentName;
    }

    /**
     * fourLevelAgentName.
     *
     * @return the fourLevelAgentName
     * @since JDK 1.8
     */
    public String getFourLevelAgentName() {
        return fourLevelAgentName;
    }

    /**
     * fourLevelAgentName.
     *
     * @param fourLevelAgentName the fourLevelAgentName to set
     * @since JDK 1.8
     */
    public void setFourLevelAgentName(String fourLevelAgentName) {
        this.fourLevelAgentName = fourLevelAgentName;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    public AccountLevelDto() {
        super();
    }

}
