package cn.com.duiba.tuia.core.api.remoteservice.newMaterial;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.core.api.dto.newMaterial.NewMaterialDto;

import java.util.List;
import java.util.Map;

/**
 * @Author:zhangmeng
 * @Date:2018-08-07
 * @Function:素材管理
 */
@AdvancedFeignClient
public interface RemoteMaterialService {

    /**
     * 保存或者更新素材
     * @param newMaterialDto
     * @return
     */
    Long save(NewMaterialDto newMaterialDto);

    /**
     * 获取该行业下的所有素材，分页展示,按照日期倒排
     * @param newTrade
     * @return
     */
    List<NewMaterialDto> getAllMaterialByTrade(String newTrade);

    /**
     *获取广告对应ae，以及广告所属行业下的素材信息（七日内）
     * @param aeId
     * @param advertId
     * @return
     */
    Map<String,List<NewMaterialDto>> getMaterialsByAeOrTrade(Long aeId, Long advertId);

    /**
     * 获取当日新素材标签
     * @return
     */
    List<String> getAllNewTrad();
}
