/**
 * Project Name:tuia-core-api<br>
 * File Name:TagDto.java<br>
 * Package Name:cn.com.duiba.tuia.core.api.dto<br>
 * Date:2016年9月27日下午7:18:45<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.core.api.dto;

import java.io.Serializable;
import java.util.List;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * ClassName: TagDto <br/>
 * Function: 标签层级关系. <br/>
 * date: 2016年9月27日 下午7:18:45 <br/>
 *
 * @author leiliang
 * @version
 * @since JDK 1.6
 */
public class TagLevel implements Serializable {

    /** The Constant serialVersionUID. */
    private static final long serialVersionUID = 1L;

    /** 标签(分类)编码. */
    private String            key;

    /** 标签(分类)名称. */
    private String            text;

    /** 子标签列表. */
    private List<TagLevel>    children;

    /**
     * The Constructor.
     */
    public TagLevel() {
        super();
    }

    /**
     * The Constructor.
     *
     * @param key the key
     * @param text the text
     */
    public TagLevel(String key, String text) {
        super();
        this.key = key;
        this.text = text;
    }

    /**
     * Gets the key.
     *
     * @return the key
     */
    public String getKey() {
        return key;
    }

    /**
     * Sets the key.
     *
     * @param key the key
     */
    public void setKey(String key) {
        this.key = key;
    }

    /**
     * Gets the text.
     *
     * @return the text
     */
    public String getText() {
        return text;
    }

    /**
     * Sets the text.
     *
     * @param text the text
     */
    public void setText(String text) {
        this.text = text;
    }

    /**
     * Gets the children.
     *
     * @return the children
     */
    public List<TagLevel> getChildren() {
        return children;
    }

    /**
     * Sets the children.
     *
     * @param children the children
     */
    public void setChildren(List<TagLevel> children) {
        this.children = children;
    }

    /**
     * To string.
     *
     * @return the string
     */
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
