/**
 * Project Name:tuia-core-api<br>
 * File Name:PspAderStatInfoDto.java<br>
 * Package Name:cn.com.duiba.tuia.core.api.dto.rsp<br>
 * Date:2017年2月7日上午9:52:29<br>
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.core.api.dto.rsp;

import java.io.Serializable;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * ClassName: PspAderStatInfoDto <br/>
 * date: 2017年2月7日 上午9:52:29 <br/>
 * .
 *
 * @author xiawei
 * @version
 * @since JDK 1.6
 */
public class RspAderStatInfoDto implements Serializable {

    /**
     * @since JDK 1.6
     */
    private static final long serialVersionUID = 806328518383585367L;

    /** 邮箱验证中. */
    private int               emailVerifyingCount;

    /** 广告主审核中. */
    private int               aderCheckingCount;

    /** 广告主审核未通过. */
    private int               aderNotPassCount;

    /** 广告主审核通过. */
    private int               aderPassCount;

    /** 广告主总数. */
    private int               aderTotalCount;

    /**
     * Gets the email verifying count.
     *
     * @return the email verifying count
     */
    public int getEmailVerifyingCount() {
        return emailVerifyingCount;
    }

    /**
     * Sets the email verifying count.
     *
     * @param emailVerifyingCount the email verifying count
     */
    public void setEmailVerifyingCount(int emailVerifyingCount) {
        this.emailVerifyingCount = emailVerifyingCount;
    }

    /**
     * Gets the ader checking count.
     *
     * @return the ader checking count
     */
    public int getAderCheckingCount() {
        return aderCheckingCount;
    }

    /**
     * Sets the ader checking count.
     *
     * @param aderCheckingCount the ader checking count
     */
    public void setAderCheckingCount(int aderCheckingCount) {
        this.aderCheckingCount = aderCheckingCount;
    }

    /**
     * Gets the ader not pass count.
     *
     * @return the ader not pass count
     */
    public int getAderNotPassCount() {
        return aderNotPassCount;
    }

    /**
     * Sets the ader not pass count.
     *
     * @param aderNotPassCount the ader not pass count
     */
    public void setAderNotPassCount(int aderNotPassCount) {
        this.aderNotPassCount = aderNotPassCount;
    }

    /**
     * Gets the ader pass count.
     *
     * @return the ader pass count
     */
    public int getAderPassCount() {
        return aderPassCount;
    }

    /**
     * Sets the ader pass count.
     *
     * @param aderPassCount the ader pass count
     */
    public void setAderPassCount(int aderPassCount) {
        this.aderPassCount = aderPassCount;
    }

    /**
     * Gets the ader total count.
     *
     * @return the ader total count
     */
    public int getAderTotalCount() {
        return aderTotalCount;
    }

    /**
     * Sets the ader total count.
     *
     * @param aderTotalCount the ader total count
     */
    public void setAderTotalCount(int aderTotalCount) {
        this.aderTotalCount = aderTotalCount;
    }

    /**
     * To string.
     *
     * @return the string
     */
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
