package cn.com.duiba.tuia.core.api.enums.permisson;


import org.apache.commons.lang.StringUtils;

/**
 * 数据权限-数据源类型
 * Created by zhengjy on 2017/3/15.
 */
public enum DataPermissonSourceTypeEnum {
    /** 广告. */
    SOURCE_TYPE_ADVERT("advert","广告"),
    /** 广告主. */
    SOURCE_TYPE_ACCOUNT("account","广告主"),
    /** 代理商. */
    SOURCE_TYPE_AGENT("agent","代理商"),
    ;

    /** 代码 */
    private String code;
    /** 描述 */
    private String desc;

     DataPermissonSourceTypeEnum(String code, String desc){
        this.code = code;
        this.desc = desc;
    }

    public static DataPermissonSourceTypeEnum getByCode(String code){
        for(DataPermissonSourceTypeEnum enumVal : DataPermissonSourceTypeEnum.values()){
            if(StringUtils.equals(code,enumVal.getCode())){
                return enumVal;
            }
        }
        return null;
    }

    public String getCode() {
        return code;
    }


    public String getDesc() {
        return desc;
    }

}
