/**
 * 文件名： UpdateCouponReq.java 此类描述的是： 作者: leiliang 创建时间: 2016年4月12日 下午2:03:36
 */
package cn.com.duiba.tuia.core.api.dto.req;

import cn.com.duiba.tuia.core.api.dto.CouponBatchSummDto;
import org.apache.commons.lang.builder.ToStringBuilder;

import java.io.Serializable;
import java.util.List;

/**
 * 修改优惠券请求
 * 
 * @author: leiliang
 * @version:
 */
public class ReqUpdateCouponDto implements Serializable {

    private static final long        serialVersionUID     = 1L;

    /** 投放端调用. */
    public static final int          CALL_TYPE_OF_TUIA    = 0;

    /** 管理端调用. */
    public static final int          CALL_TYPE_OF_MANAGER = 1;

    /** 广告ID. */
    private Long                     advertId;

    private Boolean                  isCheckPass;

    /** 推广网址. */
    private String                   promoteURL;

    /** 商品名称. */
    private String                   couponName;

    /** 商品说明. */
    private String                   couponRemark;

    /** 一句话描述. */
    private String                   description;

    /** 品牌图标. */
    private String                   thumbnailPng;

    /** 首页banner图. */
    private String                   bannerPng;

    /** 领取次数限制. */
    private Integer                  limitReceive;

    /** 优惠码类型. */
    private Integer                  codeType;

    /** 有效期批次列表. */
    private CouponBatchSummDto couponBatche;

    /**
     * 更随投放时段
     */
    private int followThrowDate = 1;

    /** 调用端：(0：投放端，1：管理端). */
    private int                      callType;

    /** 是否隐藏. 对特殊应用隐藏使用按钮(false：否，true：是). */
    private boolean                  specialHide;

    /**
     * 是否为微信券. 是否为微信券(false：否，true：是) (只有code_type=2 or code_type=3时有效) 字段名 字段类型 是否必填 字段说明 .
     */
    private boolean                  isWeixin;

    private List<String>             matchTagNums;

    /** 按钮文案. */
    private String buttonText;

    /**
     * 素材设计师
     */
    private String designer;

    public String getButtonText() {
        return buttonText;
    }

    public void setButtonText(String buttonText) {
        this.buttonText = buttonText;
    }

    public List<String> getMatchTagNums() {
        return matchTagNums;
    }

    public void setMatchTagNums(List<String> matchTagNums) {
        this.matchTagNums = matchTagNums;
    }

    public boolean isSpecialHide() {
        return specialHide;
    }

    public void setSpecialHide(boolean specialHide) {
        this.specialHide = specialHide;
    }

    public boolean isWeixin() {
        return isWeixin;
    }

    public void setWeixin(boolean isWeixin) {
        this.isWeixin = isWeixin;
    }

    public int getCallType() {
        return callType;
    }

    public void setCallType(int callType) {
        this.callType = callType;
    }

    public Long getAdvertId() {
        return advertId;
    }

    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    public Boolean getIsCheckPass() {
        return isCheckPass;
    }

    public void setIsCheckPass(Boolean isCheckPass) {
        this.isCheckPass = isCheckPass;
    }

    public String getPromoteURL() {
        return promoteURL;
    }

    public void setPromoteURL(String promoteURL) {
        this.promoteURL = promoteURL;
    }

    public String getCouponName() {
        return couponName;
    }

    public void setCouponName(String couponName) {
        this.couponName = couponName;
    }

    public String getCouponRemark() {
        return couponRemark;
    }

    public void setCouponRemark(String couponRemark) {
        this.couponRemark = couponRemark;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getThumbnailPng() {
        return thumbnailPng;
    }

    public void setThumbnailPng(String thumbnailPng) {
        this.thumbnailPng = thumbnailPng;
    }

    public String getBannerPng() {
        return bannerPng;
    }

    public void setBannerPng(String bannerPng) {
        this.bannerPng = bannerPng;
    }

    public Integer getLimitReceive() {
        return limitReceive;
    }

    public void setLimitReceive(Integer limitReceive) {
        this.limitReceive = limitReceive;
    }

    public Integer getCodeType() {
        return codeType;
    }

    public void setCodeType(Integer codeType) {
        this.codeType = codeType;
    }

    public CouponBatchSummDto getCouponBatche() {
        return couponBatche;
    }

    public void setCouponBatche(CouponBatchSummDto couponBatche) {
        this.couponBatche = couponBatche;
    }

    public int getFollowThrowDate() {
        return followThrowDate;
    }

    public void setFollowThrowDate(int followThrowDate) {
        this.followThrowDate = followThrowDate;
    }

    public String getDesigner() {
        return designer;
    }

    public void setDesigner(String designer) {
        this.designer = designer;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
