package cn.com.duiba.tuia.core.api.dto.req.data;

import org.apache.commons.lang.builder.ToStringBuilder;

import java.util.Date;
import java.util.List;

/**
 * Function: 定向配置每日预算、消费、曝光统计数据查询Dto. <br/>
 *
 * @author chencheng
 * @version
 * @since JDK 1.6
 */
public class ReqPackageAdvertDayDto extends FindListParamBaseDto {

    private static final long serialVersionUID = -8848962246172941800L;

    /** 0 or null ：汇总，1：分日 */
    private Integer           exportType;

    /** 广告定向配置ID集合. */
    private List<Long>        orientationPackageIds;
    /**广告定向包id*/
    private Long advertPackageId;
    /**广告定向包name*/
    private String orientPackageName;

    private Date curDate;
    
    /** 活动类型：0-互动广告，1-展示广告 */
    private Integer           activityType;

    /**
     * activityType.
     *
     * @return the activityType
     * @since JDK 1.8
     */
    public Integer getActivityType() {
        return activityType;
    }

    /**
     * activityType.
     *
     * @param activityType the activityType to set
     * @since JDK 1.8
     */
    public void setActivityType(Integer activityType) {
        this.activityType = activityType;
    }

    public Date getCurDate() {
        return curDate;
    }

    public void setCurDate(Date curDate) {
        this.curDate = curDate;
    }

    /**
     * orientationPackageIds.
     *
     * @return the orientationPackageIds
     */
    public List<Long> getOrientationPackageIds() {
        return orientationPackageIds;
    }

    /**
     * orientationPackageIds.
     *
     * @param orientationPackageIds the orientationPackageIds to set
     */
    public void setOrientationPackageIds(List<Long> orientationPackageIds) {
        this.orientationPackageIds = orientationPackageIds;
    }

    /**
     * exportType.
     *
     * @return the exportType
     */
    public Integer getExportType() {
        return exportType;
    }

    /**
     * exportType.
     *
     * @param exportType the exportType to set
     */
    public void setExportType(Integer exportType) {
        this.exportType = exportType;
    }

    public Long getAdvertPackageId() {
        return advertPackageId;
    }

    public void setAdvertPackageId(Long advertPackageId) {
        this.advertPackageId = advertPackageId;
    }

    public String getOrientPackageName() {
        return orientPackageName;
    }

    public void setOrientPackageName(String orientPackageName) {
        this.orientPackageName = orientPackageName;
    }

    /**
     * To string.
     *
     * @return the string
     * @see Object#toString()
     */
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
