/**
 * Project Name:tuia-advert-center-api
 * File Name:RspAdvertBudgetDayHourHistioryDto.java
 * Package Name:cn.com.duiba.tuia.core.api.dto.rsp.advert
 * Date:2017年8月24日下午3:11:43
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.tuia.core.api.dto.rsp.advert;

import java.util.Date;

import cn.com.duiba.tuia.core.api.dto.BaseDto;

/**
 * ClassName:RspAdvertBudgetDayHourHistioryDto <br/>
 * Function: 每日每小时广告状态、预算记录返回参数. <br/>
 * Date:     2017年8月24日 下午3:11:43 <br/>
 * @author   chencheng
 * @version  
 * @since    JDK 1.8
 * @see 	 
 */
public class RspAdvertBudgetDayHourHistioryDto extends BaseDto {
    
    private static final long serialVersionUID = -5562394534715866308L;

    /** 广告ID */
    private Long              advertId;

    /** 广告状态 */
    private Integer           validStatus;

    /** 广告每日预算(分) */
    private Long              budgetDay;

    /** 日期:YYYY-MM-DD */
    private Date              curDate;

    /** 对当前时间小时取整 */
    private Integer           curHour;

    /**
     * advertId.
     *
     * @return the advertId
     * @since JDK 1.8
     */
    public Long getAdvertId() {
        return advertId;
    }

    /**
     * advertId.
     *
     * @param advertId the advertId to set
     * @since JDK 1.8
     */
    public void setAdvertId(Long advertId) {
        this.advertId = advertId;
    }

    /**
     * validStatus.
     *
     * @return the validStatus
     * @since JDK 1.8
     */
    public Integer getValidStatus() {
        return validStatus;
    }

    /**
     * validStatus.
     *
     * @param validStatus the validStatus to set
     * @since JDK 1.8
     */
    public void setValidStatus(Integer validStatus) {
        this.validStatus = validStatus;
    }

    /**
     * budgetDay.
     *
     * @return the budgetDay
     * @since JDK 1.8
     */
    public Long getBudgetDay() {
        return budgetDay;
    }

    /**
     * budgetDay.
     *
     * @param budgetDay the budgetDay to set
     * @since JDK 1.8
     */
    public void setBudgetDay(Long budgetDay) {
        this.budgetDay = budgetDay;
    }

    /**
     * curDate.
     *
     * @return the curDate
     * @since JDK 1.8
     */
    public Date getCurDate() {
        return curDate;
    }

    /**
     * curDate.
     *
     * @param curDate the curDate to set
     * @since JDK 1.8
     */
    public void setCurDate(Date curDate) {
        this.curDate = curDate;
    }

    /**
     * curHour.
     *
     * @return the curHour
     * @since JDK 1.8
     */
    public Integer getCurHour() {
        return curHour;
    }

    /**
     * curHour.
     *
     * @param curHour the curHour to set
     * @since JDK 1.8
     */
    public void setCurHour(Integer curHour) {
        this.curHour = curHour;
    }

}

