/**
 * Project Name:tuia-advert-center-api
 * File Name:RemoteWelfareFlowAdvertService.java
 * Package Name:cn.com.duiba.tuia.core.api.remoteservice.advert
 * Date:2018年7月13日上午10:09:56
 * Copyright (c) 2018, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.tuia.core.api.remoteservice.advert;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * ClassName:RemoteWelfareFlowAdvertService <br/>
 * Function: 福利流量广告. <br/>
 * Date:     2018年7月13日 上午10:09:56 <br/>
 * @author   chencheng
 * @version  
 * @since    JDK 1.8
 * @see 	 s
 */
@AdvancedFeignClient
public interface RemoteWelfareFlowAdvertService {

    /**
     * 
     * deleteAdvertAppWelfareFlow:(删除今日可投的福利流量广告,更新为已删除). <br/>
     *
     * @author chencheng
     * @param advertId
     * @return
     * @since JDK 1.8
     */
    Integer deleteAdvertAppWelfareFlow(Long advertId);
    
    /**
     * 
     * deleteAdvertAppWelfareFlow:(删除数据,日期：yyyy-mm-dd，小时：hh:mi). <br/>
     *
     * @author chencheng
     * @param lastWelfareFlowDO
     * @return
     * @since JDK 1.8
     */
    Integer deleteAdvertAppWelfareFlowByDate(String curDate, String curHour);
}

