package cn.com.duiba.tuia.core.api.enums.fincance;

/**
 * Created by lizhihui on 2017-10-19 16:29.
 */
public enum ApplicationStatus {
                               COMMIT_NEW(11,"助理待审核"), // 新提交状态(助理待审核)

                               COMMIT_FALSE(10,"提交失败"), // 提交失败

                               ASSISTANT_AGREE(21,"主管待审核"), // 助理同意状态(主管待审核)

                               ASSISTANT_REFUSE(20,"助理拒绝"), // 助理拒绝状态

                               MANAGER_AGREE(31,"主管同意"), // 主管同意状态(会自动发起充值)

                               MANAGER_REFUSE(30,"主管拒绝"), // 主管拒绝状态

                               RECHARGE_SUCCESS(41,"充值完成"), // 自动充值成功状态

                               RECHARGE_FAILED(40,"充值失败"),// 自动充值失败状态

    ;

    private Integer status;
    private String desc;

    ApplicationStatus(Integer status,String desc) {
        this.status = status;
        this.desc=desc;
    }

    public Integer getStatus() {
        return status;
    }

    public String getDesc() {
        return desc;
    }

    public static String getDesc(Integer status) {
        for (ApplicationStatus applicationStatus : ApplicationStatus.values()) {
            if (applicationStatus.getStatus().equals(status)) {
                return applicationStatus.getDesc();
            }
        }
        return null;
    }
}
